/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.expr.ast;

import space.yizhu.record.template.TemplateException;
import space.yizhu.record.template.expr.ast.Expr;
import space.yizhu.record.template.expr.ast.ExprList;
import space.yizhu.record.template.expr.ast.Method;
import space.yizhu.record.template.expr.ast.MethodKit;
import space.yizhu.record.template.expr.ast.SharedMethodKit;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;

public class SharedMethod
extends Expr {
    private SharedMethodKit sharedMethodKit;
    private String methodName;
    private ExprList exprList;

    public SharedMethod(SharedMethodKit sharedMethodKit, String methodName, ExprList exprList, Location location) {
        if (MethodKit.isForbiddenMethod(methodName)) {
            throw new ParseException("Forbidden method: " + methodName, location);
        }
        this.sharedMethodKit = sharedMethodKit;
        this.methodName = methodName;
        this.exprList = exprList;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Object[] argValues = this.exprList.evalExprList(scope);
        try {
            SharedMethodKit.SharedMethodInfo sharedMethodInfo = this.sharedMethodKit.getSharedMethodInfo(this.methodName, argValues);
            if (sharedMethodInfo != null) {
                return sharedMethodInfo.invoke(argValues);
            }
            throw new TemplateException(Method.buildMethodNotFoundSignature("Shared method not found: ", this.methodName, argValues), this.location);
        }
        catch (TemplateException | ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

