/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.expr.ast;

import java.lang.reflect.Field;
import space.yizhu.record.template.TemplateException;
import space.yizhu.record.template.expr.ast.Expr;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;

public class StaticField
extends Expr {
    private Class<?> clazz;
    private String fieldName;
    private Field field;

    public StaticField(String className, String fieldName, Location location) {
        try {
            this.clazz = Class.forName(className);
            this.fieldName = fieldName;
            this.field = this.clazz.getField(fieldName);
            this.location = location;
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), location, e);
        }
    }

    @Override
    public Object eval(Scope scope) {
        try {
            return this.field.get(null);
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }

    public String toString() {
        return this.clazz.getName() + "::" + this.fieldName;
    }
}

