/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.expr.ast;

import space.yizhu.record.template.expr.ast.Expr;
import space.yizhu.record.template.expr.ast.Logic;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;

public class Ternary
extends Expr {
    private Expr cond;
    private Expr exprOne;
    private Expr exprTwo;

    public Ternary(Expr cond, Expr exprOne, Expr exprTwo, Location location) {
        if (cond == null || exprOne == null || exprTwo == null) {
            throw new ParseException("The parameter of ternary expression can not be blank", location);
        }
        this.cond = cond;
        this.exprOne = exprOne;
        this.exprTwo = exprTwo;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        return Logic.isTrue(this.cond.eval(scope)) ? this.exprOne.eval(scope) : this.exprTwo.eval(scope);
    }
}

