/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.ext.directive;

import java.util.ArrayList;
import space.yizhu.record.template.Directive;
import space.yizhu.record.template.Env;
import space.yizhu.record.template.TemplateException;
import space.yizhu.record.template.expr.ast.Const;
import space.yizhu.record.template.expr.ast.Expr;
import space.yizhu.record.template.expr.ast.ExprList;
import space.yizhu.record.template.io.Writer;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;
import space.yizhu.record.template.stat.ast.Define;

public class CallDirective
extends Directive {
    protected Expr funcNameExpr;
    protected ExprList paraExpr;
    protected boolean nullSafe = false;

    @Override
    public void setExprList(ExprList exprList) {
        int len = exprList.length();
        if (len == 0) {
            throw new ParseException("\u6a21\u677f\u51fd\u6570\u540d\u4e0d\u80fd\u7f3a\u5931", this.location);
        }
        int index = 0;
        Expr expr = exprList.getExpr(index);
        if (expr instanceof Const && ((Const)expr).isBoolean()) {
            if (len == 1) {
                throw new ParseException("\u6a21\u677f\u51fd\u6570\u540d\u4e0d\u80fd\u7f3a\u5931", this.location);
            }
            this.nullSafe = ((Const)expr).getBoolean();
        }
        int n = ++index;
        this.funcNameExpr = exprList.getExpr(n);
        ArrayList<Expr> list = new ArrayList<Expr>();
        for (int i = ++index; i < len; ++i) {
            list.add(exprList.getExpr(i));
        }
        this.paraExpr = new ExprList(list);
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        Object funcNameValue = this.funcNameExpr.eval(scope);
        if (funcNameValue == null) {
            if (this.nullSafe) {
                return;
            }
            throw new TemplateException("\u6a21\u677f\u51fd\u6570\u540d\u4e3a null", this.location);
        }
        if (!(funcNameValue instanceof String)) {
            throw new TemplateException("\u6a21\u677f\u51fd\u6570\u540d\u5fc5\u987b\u662f\u5b57\u7b26\u4e32", this.location);
        }
        Define func = env.getFunction(funcNameValue.toString());
        if (func == null) {
            if (this.nullSafe) {
                return;
            }
            throw new TemplateException("\u6a21\u677f\u51fd\u6570\u672a\u627e\u5230 : " + funcNameValue, this.location);
        }
        func.call(env, scope, this.paraExpr, writer);
    }
}

