/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.ext.directive;

import java.io.IOException;
import java.util.Date;
import space.yizhu.record.template.Directive;
import space.yizhu.record.template.Env;
import space.yizhu.record.template.TemplateException;
import space.yizhu.record.template.expr.ast.ExprList;
import space.yizhu.record.template.io.Writer;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;

public class NowDirective
extends Directive {
    @Override
    public void setExprList(ExprList exprList) {
        if (exprList.length() > 1) {
            throw new ParseException("#now directive support one parameter only", this.location);
        }
        super.setExprList(exprList);
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        String datePattern;
        if (this.exprList.length() == 0) {
            datePattern = env.getEngineConfig().getDatePattern();
        } else {
            Object dp = this.exprList.eval(scope);
            if (dp instanceof String) {
                datePattern = (String)dp;
            } else {
                throw new TemplateException("The parameter of #now directive must be String", this.location);
            }
        }
        try {
            writer.write(new Date(), datePattern);
        }
        catch (IOException e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

