/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.io;

class FDBigInt {
    int nWords;
    int[] data;

    public FDBigInt(long v) {
        this.data = new int[2];
        this.data[0] = (int)v;
        this.data[1] = (int)(v >>> 32);
        this.nWords = this.data[1] == 0 ? 1 : 2;
    }

    public FDBigInt(FDBigInt other) {
        this.nWords = other.nWords;
        this.data = new int[this.nWords];
        System.arraycopy(other.data, 0, this.data, 0, this.nWords);
    }

    private FDBigInt(int[] d, int n) {
        this.data = d;
        this.nWords = n;
    }

    public void lshiftMe(int c) throws IllegalArgumentException {
        if (c <= 0) {
            if (c == 0) {
                return;
            }
            throw new IllegalArgumentException("negative shift count");
        }
        int wordcount = c >> 5;
        int bitcount = c & 0x1F;
        int anticount = 32 - bitcount;
        int[] t = this.data;
        int[] s = this.data;
        if (this.nWords + wordcount + 1 > t.length) {
            t = new int[this.nWords + wordcount + 1];
        }
        int target = this.nWords + wordcount;
        int src = this.nWords - 1;
        if (bitcount == 0) {
            System.arraycopy(s, 0, t, wordcount, this.nWords);
            target = wordcount - 1;
        } else {
            t[target--] = s[src] >>> anticount;
            while (src >= 1) {
                t[target--] = s[src] << bitcount | s[--src] >>> anticount;
            }
            t[target--] = s[src] << bitcount;
        }
        while (target >= 0) {
            t[target--] = 0;
        }
        this.data = t;
        this.nWords += wordcount + 1;
        while (this.nWords > 1 && this.data[this.nWords - 1] == 0) {
            --this.nWords;
        }
    }

    public int normalizeMe() throws IllegalArgumentException {
        int src;
        int wordcount = 0;
        int bitcount = 0;
        int v = 0;
        for (src = this.nWords - 1; src >= 0 && (v = this.data[src]) == 0; --src) {
            ++wordcount;
        }
        if (src < 0) {
            throw new IllegalArgumentException("zero value");
        }
        this.nWords -= wordcount;
        if ((v & 0xF0000000) != 0) {
            bitcount = 32;
            while ((v & 0xF0000000) != 0) {
                v >>>= 1;
                --bitcount;
            }
        } else {
            while (v <= 1048575) {
                v <<= 8;
                bitcount += 8;
            }
            while (v <= 0x7FFFFFF) {
                v <<= 1;
                ++bitcount;
            }
        }
        if (bitcount != 0) {
            this.lshiftMe(bitcount);
        }
        return bitcount;
    }

    public FDBigInt mult(int iv) {
        long v = iv;
        int[] r = new int[v * ((long)this.data[this.nWords - 1] & 0xFFFFFFFFL) > 0xFFFFFFFL ? this.nWords + 1 : this.nWords];
        long p = 0L;
        for (int i = 0; i < this.nWords; ++i) {
            r[i] = (int)(p += v * ((long)this.data[i] & 0xFFFFFFFFL));
            p >>>= 32;
        }
        if (p == 0L) {
            return new FDBigInt(r, this.nWords);
        }
        r[this.nWords] = (int)p;
        return new FDBigInt(r, this.nWords + 1);
    }

    public FDBigInt mult(FDBigInt other) {
        int i;
        int[] r = new int[this.nWords + other.nWords];
        for (i = 0; i < this.nWords; ++i) {
            long v = (long)this.data[i] & 0xFFFFFFFFL;
            long p = 0L;
            for (int j = 0; j < other.nWords; ++j) {
                r[i + j] = (int)(p += ((long)r[i + j] & 0xFFFFFFFFL) + v * ((long)other.data[j] & 0xFFFFFFFFL));
                p >>>= 32;
            }
            r[i + j] = (int)p;
        }
        for (i = r.length - 1; i > 0 && r[i] == 0; --i) {
        }
        return new FDBigInt(r, i + 1);
    }

    public FDBigInt add(FDBigInt other) {
        int i;
        int m;
        int[] b;
        int n;
        int[] a;
        long c = 0L;
        if (this.nWords >= other.nWords) {
            a = this.data;
            n = this.nWords;
            b = other.data;
            m = other.nWords;
        } else {
            a = other.data;
            n = other.nWords;
            b = this.data;
            m = this.nWords;
        }
        int[] r = new int[n];
        for (i = 0; i < n; ++i) {
            c += (long)a[i] & 0xFFFFFFFFL;
            if (i < m) {
                c += (long)b[i] & 0xFFFFFFFFL;
            }
            r[i] = (int)c;
            c >>= 32;
        }
        if (c != 0L) {
            int[] s = new int[r.length + 1];
            System.arraycopy(r, 0, s, 0, r.length);
            s[i++] = (int)c;
            return new FDBigInt(s, i);
        }
        return new FDBigInt(r, i);
    }

    public int cmp(FDBigInt other) {
        int i;
        int j;
        if (this.nWords > other.nWords) {
            j = other.nWords - 1;
            for (i = this.nWords - 1; i > j; --i) {
                if (this.data[i] == 0) continue;
                return 1;
            }
        } else if (this.nWords < other.nWords) {
            j = this.nWords - 1;
            for (i = other.nWords - 1; i > j; --i) {
                if (other.data[i] == 0) continue;
                return -1;
            }
        } else {
            i = this.nWords - 1;
        }
        while (i > 0 && this.data[i] == other.data[i]) {
            --i;
        }
        int a = this.data[i];
        int b = other.data[i];
        if (a < 0) {
            if (b < 0) {
                return a - b;
            }
            return 1;
        }
        if (b < 0) {
            return -1;
        }
        return a - b;
    }

    public int quoRemIteration(FDBigInt S) throws IllegalArgumentException {
        int i;
        if (this.nWords != S.nWords) {
            throw new IllegalArgumentException("disparate values");
        }
        int n = this.nWords - 1;
        long q = ((long)this.data[n] & 0xFFFFFFFFL) / (long)S.data[n];
        long diff = 0L;
        for (int i2 = 0; i2 <= n; ++i2) {
            this.data[i2] = (int)(diff += ((long)this.data[i2] & 0xFFFFFFFFL) - q * ((long)S.data[i2] & 0xFFFFFFFFL));
            diff >>= 32;
        }
        if (diff != 0L) {
            long sum = 0L;
            while (sum == 0L) {
                sum = 0L;
                for (i = 0; i <= n; ++i) {
                    this.data[i] = (int)(sum += ((long)this.data[i] & 0xFFFFFFFFL) + ((long)S.data[i] & 0xFFFFFFFFL));
                    sum >>= 32;
                }
                assert (sum == 0L || sum == 1L) : sum;
                --q;
            }
        }
        long p = 0L;
        for (i = 0; i <= n; ++i) {
            this.data[i] = (int)(p += 10L * ((long)this.data[i] & 0xFFFFFFFFL));
            p >>= 32;
        }
        assert (p == 0L) : p;
        return (int)q;
    }

    public String toString() {
        StringBuffer r = new StringBuffer(30);
        r.append('[');
        int i = Math.min(this.nWords - 1, this.data.length - 1);
        if (this.nWords > this.data.length) {
            r.append("(" + this.data.length + "<" + this.nWords + "!)");
        }
        while (i > 0) {
            r.append(Integer.toHexString(this.data[i]));
            r.append(' ');
            --i;
        }
        r.append(Integer.toHexString(this.data[0]));
        r.append(']');
        return new String(r);
    }
}

