/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.io;

import java.nio.charset.MalformedInputException;
import space.yizhu.record.template.io.Encoder;

public class Utf8Encoder
extends Encoder {
    public static final Utf8Encoder me = new Utf8Encoder();

    @Override
    public float maxBytesPerChar() {
        return 3.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int encode(char[] chars, int offset, int len, byte[] bytes) {
        int sl = offset + len;
        int dp = 0;
        int dlASCII = dp + Math.min(len, bytes.length);
        while (dp < dlASCII && chars[offset] < '\u0080') {
            bytes[dp++] = (byte)chars[offset++];
        }
        while (offset < sl) {
            int c;
            if ((c = chars[offset++]) < 128) {
                bytes[dp++] = (byte)c;
                continue;
            }
            if (c < 2048) {
                bytes[dp++] = (byte)(0xC0 | c >> 6);
                bytes[dp++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c >= 55296 && c < 57344) {
                int uc;
                int ip = offset - 1;
                if (Character.isHighSurrogate((char)c)) {
                    if (sl - ip < 2) {
                        uc = -1;
                    } else {
                        char d = chars[ip + 1];
                        if (!Character.isLowSurrogate(d)) throw new RuntimeException("encode UTF8 error", new MalformedInputException(1));
                        uc = Character.toCodePoint((char)c, d);
                    }
                } else {
                    if (Character.isLowSurrogate((char)c)) {
                        throw new RuntimeException("encode UTF8 error", new MalformedInputException(1));
                    }
                    uc = c;
                }
                if (uc < 0) {
                    bytes[dp++] = 63;
                    continue;
                }
                bytes[dp++] = (byte)(0xF0 | uc >> 18);
                bytes[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                bytes[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                bytes[dp++] = (byte)(0x80 | uc & 0x3F);
                ++offset;
                continue;
            }
            bytes[dp++] = (byte)(0xE0 | c >> 12);
            bytes[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
            bytes[dp++] = (byte)(0x80 | c & 0x3F);
        }
        return dp;
    }
}

