/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.source;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import space.yizhu.kits.LogKit;
import space.yizhu.record.template.source.ISource;

public class ClassPathSource
implements ISource {
    protected String finalFileName;
    protected String fileName;
    protected String encoding;
    protected boolean isInJar;
    protected long lastModified;
    protected ClassLoader classLoader;
    protected URL url;

    public ClassPathSource(String fileName) {
        this(null, fileName, "UTF-8");
    }

    public ClassPathSource(String baseTemplatePath, String fileName) {
        this(baseTemplatePath, fileName, "UTF-8");
    }

    public ClassPathSource(String baseTemplatePath, String fileName, String encoding) {
        this.finalFileName = this.buildFinalFileName(baseTemplatePath, fileName);
        this.fileName = fileName;
        this.encoding = encoding;
        this.classLoader = this.getClassLoader();
        this.url = this.classLoader.getResource(this.finalFileName);
        if (this.url == null) {
            throw new IllegalArgumentException("File not found : \"" + this.finalFileName + "\"");
        }
        this.processIsInJarAndlastModified();
    }

    protected void processIsInJarAndlastModified() {
        if ("file".equalsIgnoreCase(this.url.getProtocol())) {
            this.isInJar = false;
            this.lastModified = new File(this.url.getFile()).lastModified();
        } else {
            this.isInJar = true;
            this.lastModified = -1L;
        }
    }

    protected ClassLoader getClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret : this.getClass().getClassLoader();
    }

    protected String buildFinalFileName(String baseTemplatePath, String fileName) {
        char firstChar;
        String finalFileName = baseTemplatePath != null ? ((firstChar = fileName.charAt(0)) == '/' || firstChar == '\\' ? baseTemplatePath + fileName : baseTemplatePath + "/" + fileName) : fileName;
        if (finalFileName.charAt(0) == '/') {
            finalFileName = finalFileName.substring(1);
        }
        return finalFileName;
    }

    @Override
    public String getCacheKey() {
        return this.fileName;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    protected long getLastModified() {
        return new File(this.url.getFile()).lastModified();
    }

    @Override
    public boolean isModified() {
        return this.isInJar ? false : this.lastModified != this.getLastModified();
    }

    @Override
    public StringBuilder getContent() {
        InputStream inputStream;
        if (!this.isInJar) {
            this.lastModified = this.getLastModified();
        }
        if ((inputStream = this.classLoader.getResourceAsStream(this.finalFileName)) == null) {
            throw new RuntimeException("File not found : \"" + this.finalFileName + "\"");
        }
        return ClassPathSource.loadFile(inputStream, this.encoding);
    }

    public static StringBuilder loadFile(InputStream inputStream, String encoding) {
        StringBuilder ret = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(inputStream, encoding));
            String line = br.readLine();
            if (line != null) {
                ret.append(line);
            } else {
                StringBuilder stringBuilder = ret;
                return stringBuilder;
            }
            while ((line = br.readLine()) != null) {
                ret.append('\n').append(line);
            }
            StringBuilder stringBuilder = ret;
            return stringBuilder;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("In Jar File: ").append(this.isInJar).append("\n");
        sb.append("File name: ").append(this.fileName).append("\n");
        sb.append("Final file name: ").append(this.finalFileName).append("\n");
        sb.append("Last modified: ").append(this.lastModified).append("\n");
        return sb.toString();
    }
}

