/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.stat;

import java.util.ArrayList;
import java.util.List;
import space.yizhu.record.template.stat.CharTable;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParaToken;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Symbol;
import space.yizhu.record.template.stat.TextToken;
import space.yizhu.record.template.stat.Token;

class Lexer {
    static final char EOF = '\uffff';
    static final int TEXT_STATE_DIAGRAM = 999;
    char[] buf;
    int state = 0;
    int lexemeBegin = 0;
    int forward = 0;
    int beginRow = 1;
    int forwardRow = 1;
    TextToken previousTextToken = null;
    List<Token> tokens = new ArrayList<Token>();
    String fileName;

    public Lexer(StringBuilder content, String fileName) {
        int len = content.length();
        this.buf = new char[len + 1];
        content.getChars(0, content.length(), this.buf, 0);
        this.buf[len] = 65535;
        this.fileName = fileName;
    }

    public List<Token> scan() {
        while (this.peek() != '\uffff') {
            if (this.peek() == '#' && (this.scanDire() || this.scanSingleLineComment() || this.scanMultiLineComment() || this.scanNoParse())) continue;
            this.scanText();
        }
        return this.tokens;
    }

    boolean scanDire() {
        String id = null;
        StringBuilder para = null;
        Token idToken = null;
        ParaToken paraToken = null;
        block8: while (true) {
            switch (this.state) {
                case 0: {
                    if (this.peek() == '#') {
                        this.next();
                        this.skipBlanks();
                        this.state = 1;
                        continue block8;
                    }
                    return this.fail();
                }
                case 1: {
                    if (this.peek() == '(') {
                        para = this.scanPara("");
                        idToken = new Token(Symbol.OUTPUT, this.beginRow);
                        paraToken = new ParaToken(para, this.beginRow);
                        return this.addOutputToken(idToken, paraToken);
                    }
                    if (CharTable.isLetter(this.peek())) {
                        this.state = 10;
                        continue block8;
                    }
                    if (this.peek() == '@') {
                        this.next();
                        this.skipBlanks();
                        if (CharTable.isLetter(this.peek())) {
                            this.state = 20;
                            continue block8;
                        }
                    }
                    return this.fail();
                }
                case 10: {
                    id = this.scanId();
                    Symbol symbol = Symbol.getKeywordSym(id);
                    if (symbol == null) {
                        this.state = 11;
                        continue block8;
                    }
                    if (symbol == Symbol.DEFINE) {
                        this.state = 12;
                        continue block8;
                    }
                    if (symbol == Symbol.ELSE && this.foundFollowingIf()) {
                        id = "else if";
                        symbol = Symbol.ELSEIF;
                    }
                    if (symbol.noPara()) {
                        return this.addNoParaToken(new Token(symbol, id, this.beginRow));
                    }
                    this.skipBlanks();
                    if (this.peek() == '(') {
                        para = this.scanPara(id);
                        idToken = new Token(symbol, this.beginRow);
                        paraToken = new ParaToken(para, this.beginRow);
                        return this.addIdParaToken(idToken, paraToken);
                    }
                    throw new ParseException("#" + id + " directive requires parentheses \"()\"", new Location(this.fileName, this.beginRow));
                }
                case 11: {
                    this.skipBlanks();
                    if (this.peek() == '(') {
                        para = this.scanPara(id);
                        idToken = new Token(Symbol.ID, id, this.beginRow);
                        paraToken = new ParaToken(para, this.beginRow);
                        return this.addIdParaToken(idToken, paraToken);
                    }
                    return this.fail();
                }
                case 12: {
                    this.skipBlanks();
                    if (CharTable.isLetter(this.peek())) {
                        id = this.scanId();
                        this.skipBlanks();
                        if (this.peek() == '(') {
                            para = this.scanPara("define " + id);
                            idToken = new Token(Symbol.DEFINE, id, this.beginRow);
                            paraToken = new ParaToken(para, this.beginRow);
                            return this.addIdParaToken(idToken, paraToken);
                        }
                        throw new ParseException("#define " + id + " : template function definition requires parentheses \"()\"", new Location(this.fileName, this.beginRow));
                    }
                    throw new ParseException("#define directive requires identifier as a function name", new Location(this.fileName, this.beginRow));
                }
                case 20: {
                    boolean hasQuestionMark;
                    id = this.scanId();
                    this.skipBlanks();
                    boolean bl = hasQuestionMark = this.peek() == '?';
                    if (hasQuestionMark) {
                        this.next();
                        this.skipBlanks();
                    }
                    if (this.peek() == '(') {
                        para = this.scanPara(hasQuestionMark ? "@" + id + "?" : "@" + id);
                        idToken = new Token(hasQuestionMark ? Symbol.CALL_IF_DEFINED : Symbol.CALL, id, this.beginRow);
                        paraToken = new ParaToken(para, this.beginRow);
                        return this.addIdParaToken(idToken, paraToken);
                    }
                    return this.fail();
                }
            }
            break;
        }
        return this.fail();
    }

    boolean foundFollowingIf() {
        int p = this.forward;
        while (CharTable.isBlank(this.buf[p])) {
            ++p;
        }
        if (this.buf[p++] == 'i' && this.buf[p++] == 'f') {
            while (CharTable.isBlank(this.buf[p])) {
                ++p;
            }
            if (this.buf[p] == '(') {
                this.forward = p;
                return true;
            }
        }
        return false;
    }

    String scanId() {
        int idStart = this.forward;
        while (CharTable.isLetterOrDigit(this.next())) {
        }
        return this.subBuf(idStart, this.forward - 1).toString();
    }

    StringBuilder scanPara(String id) {
        char quotes = '\"';
        int localState = 0;
        int parenDepth = 1;
        this.next();
        int paraStart = this.forward;
        while (true) {
            block0 : switch (localState) {
                case 0: {
                    char c = this.peek();
                    while (true) {
                        if (c == ')') {
                            if (--parenDepth == 0) {
                                this.next();
                                return this.subBuf(paraStart, this.forward - 2);
                            }
                        } else if (c == '(') {
                            ++parenDepth;
                        } else {
                            if (c == '\"' || c == '\'') {
                                quotes = c;
                                localState = 1;
                                break block0;
                            }
                            if (!CharTable.isExprChar(c)) {
                                if (c == '\uffff') {
                                    throw new ParseException("#" + id + " parameter can not match the end char ')'", new Location(this.fileName, this.beginRow));
                                }
                                throw new ParseException("#" + id + " parameter exists illegal char: '" + c + "'", new Location(this.fileName, this.beginRow));
                            }
                        }
                        c = this.next();
                    }
                }
                case 1: {
                    char c = this.next();
                    while (true) {
                        if (c == quotes) {
                            if (this.buf[this.forward - 1] != '\\') {
                                this.next();
                                localState = 0;
                                break block0;
                            }
                        } else if (c == '\uffff') {
                            throw new ParseException("#" + id + " parameter error, the string parameter not ending", new Location(this.fileName, this.beginRow));
                        }
                        c = this.next();
                    }
                }
            }
        }
    }

    boolean scanSingleLineComment() {
        block4: while (true) {
            switch (this.state) {
                case 100: {
                    if (this.peek() == '#' && this.next() == '#' && this.next() == '#') {
                        this.state = 101;
                        continue block4;
                    }
                    return this.fail();
                }
                case 101: {
                    char c = this.next();
                    while (true) {
                        if (c == '\n') {
                            if (this.deletePreviousTextTokenBlankTails()) {
                                return this.prepareNextScan(1);
                            }
                            return this.prepareNextScan(0);
                        }
                        if (c == '\uffff') {
                            this.deletePreviousTextTokenBlankTails();
                            return this.prepareNextScan(0);
                        }
                        c = this.next();
                    }
                }
            }
            break;
        }
        return this.fail();
    }

    boolean scanMultiLineComment() {
        block4: while (true) {
            switch (this.state) {
                case 200: {
                    if (this.peek() == '#' && this.next() == '-' && this.next() == '-') {
                        this.state = 201;
                        continue block4;
                    }
                    return this.fail();
                }
                case 201: {
                    char c = this.next();
                    while (true) {
                        if (c == '-' && this.buf[this.forward + 1] == '-' && this.buf[this.forward + 2] == '#') {
                            this.forward += 3;
                            if (this.lookForwardLineFeedAndEof() && this.deletePreviousTextTokenBlankTails()) {
                                return this.prepareNextScan(this.peek() != '\uffff' ? 1 : 0);
                            }
                            return this.prepareNextScan(0);
                        }
                        if (c == '\uffff') {
                            throw new ParseException("The multiline comment start block \"#--\" can not match the end block: \"--#\"", new Location(this.fileName, this.beginRow));
                        }
                        c = this.next();
                    }
                }
            }
            break;
        }
        return this.fail();
    }

    boolean scanNoParse() {
        block4: while (true) {
            switch (this.state) {
                case 300: {
                    if (this.peek() == '#' && this.next() == '[' && this.next() == '[') {
                        this.state = 301;
                        continue block4;
                    }
                    return this.fail();
                }
                case 301: {
                    char c = this.next();
                    while (true) {
                        if (c == ']' && this.buf[this.forward + 1] == ']' && this.buf[this.forward + 2] == '#') {
                            this.addTextToken(this.subBuf(this.lexemeBegin + 3, this.forward - 1));
                            return this.prepareNextScan(3);
                        }
                        if (c == '\uffff') {
                            throw new ParseException("The \"no parse\" start block \"#[[\" can not match the end block: \"]]#\"", new Location(this.fileName, this.beginRow));
                        }
                        c = this.next();
                    }
                }
            }
            break;
        }
        return this.fail();
    }

    boolean scanText() {
        char c = this.peek();
        while (true) {
            if (c == '#' || c == '\uffff') {
                this.addTextToken(this.subBuf(this.lexemeBegin, this.forward - 1));
                return this.prepareNextScan(0);
            }
            c = this.next();
        }
    }

    boolean fail() {
        if (this.state < 300) {
            this.forward = this.lexemeBegin;
            this.forwardRow = this.beginRow;
        }
        this.state = this.state < 100 ? 100 : (this.state < 200 ? 200 : (this.state < 300 ? 300 : 999));
        return false;
    }

    char next() {
        if (this.buf[this.forward] == '\n') {
            ++this.forwardRow;
        }
        return this.buf[++this.forward];
    }

    char peek() {
        return this.buf[this.forward];
    }

    void skipBlanks() {
        while (CharTable.isBlank(this.buf[this.forward])) {
            this.next();
        }
    }

    StringBuilder subBuf(int start, int end) {
        if (start > end) {
            return null;
        }
        StringBuilder ret = new StringBuilder(end - start + 1);
        for (int i = start; i <= end; ++i) {
            ret.append(this.buf[i]);
        }
        return ret;
    }

    boolean prepareNextScan(int moveForward) {
        for (int i = 0; i < moveForward; ++i) {
            this.next();
        }
        this.state = 0;
        this.lexemeBegin = this.forward;
        this.beginRow = this.forwardRow;
        return true;
    }

    void addTextToken(StringBuilder text) {
        if (text == null || text.length() == 0) {
            return;
        }
        if (this.previousTextToken != null) {
            this.previousTextToken.append(text);
        } else {
            this.previousTextToken = new TextToken(text, this.beginRow);
            this.tokens.add(this.previousTextToken);
        }
    }

    boolean addOutputToken(Token idToken, Token paraToken) {
        this.tokens.add(idToken);
        this.tokens.add(paraToken);
        this.previousTextToken = null;
        return this.prepareNextScan(0);
    }

    boolean lookForwardLineFeedAndEof() {
        int forwardBak = this.forward;
        int forwardRowBak = this.forwardRow;
        char c = this.peek();
        while (true) {
            if (!CharTable.isBlank(c)) {
                if (c == '\n' || c == '\uffff') {
                    return true;
                }
                this.forward = forwardBak;
                this.forwardRow = forwardRowBak;
                return false;
            }
            c = this.next();
        }
    }

    boolean addIdParaToken(Token idToken, Token paraToken) {
        this.tokens.add(idToken);
        this.tokens.add(paraToken);
        if (this.lookForwardLineFeedAndEof() && this.deletePreviousTextTokenBlankTails()) {
            this.prepareNextScan(this.peek() != '\uffff' ? 1 : 0);
        } else {
            this.prepareNextScan(0);
        }
        this.previousTextToken = null;
        return true;
    }

    boolean addNoParaToken(Token noParaToken) {
        this.tokens.add(noParaToken);
        if (CharTable.isBlank(this.peek())) {
            this.next();
        }
        if (this.lookForwardLineFeedAndEof() && this.deletePreviousTextTokenBlankTails()) {
            this.prepareNextScan(this.peek() != '\uffff' ? 1 : 0);
        } else {
            this.prepareNextScan(0);
        }
        this.previousTextToken = null;
        return true;
    }

    boolean deletePreviousTextTokenBlankTails() {
        return this.previousTextToken == null || this.previousTextToken.deleteBlankTails();
    }
}

