/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.stat.ast;

import space.yizhu.record.template.Env;
import space.yizhu.record.template.TemplateException;
import space.yizhu.record.template.expr.ast.Expr;
import space.yizhu.record.template.expr.ast.ExprList;
import space.yizhu.record.template.io.Writer;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;
import space.yizhu.record.template.stat.ast.CaseSetter;
import space.yizhu.record.template.stat.ast.Stat;
import space.yizhu.record.template.stat.ast.StatList;

public class Case
extends Stat
implements CaseSetter {
    private Expr[] exprArray;
    private Stat stat;
    private Case nextCase;

    public Case(ExprList exprList, StatList statList, Location location) {
        if (exprList.length() == 0) {
            throw new ParseException("The parameter of #case directive can not be blank", location);
        }
        this.exprArray = exprList.getExprArray();
        this.stat = statList.getActualStat();
    }

    @Override
    public void setNextCase(Case nextCase) {
        this.nextCase = nextCase;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        throw new TemplateException("#case \u6307\u4ee4\u7684 exec \u4e0d\u80fd\u88ab\u8c03\u7528", this.location);
    }

    boolean execIfMatch(Object switchValue, Env env, Scope scope, Writer writer) {
        if (this.exprArray.length == 1) {
            Object value = this.exprArray[0].eval(scope);
            if (value == switchValue) {
                this.stat.exec(env, scope, writer);
                return true;
            }
            if (value != null && value.equals(switchValue)) {
                this.stat.exec(env, scope, writer);
                return true;
            }
        } else {
            for (Expr expr : this.exprArray) {
                Object value = expr.eval(scope);
                if (value == switchValue) {
                    this.stat.exec(env, scope, writer);
                    return true;
                }
                if (value == null || !value.equals(switchValue)) continue;
                this.stat.exec(env, scope, writer);
                return true;
            }
        }
        return this.nextCase != null ? this.nextCase.execIfMatch(switchValue, env, scope, writer) : false;
    }
}

