/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.stat.ast;

import space.yizhu.record.template.Env;
import space.yizhu.record.template.expr.ast.Expr;
import space.yizhu.record.template.expr.ast.ExprList;
import space.yizhu.record.template.expr.ast.Logic;
import space.yizhu.record.template.io.Writer;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;
import space.yizhu.record.template.stat.ast.Stat;
import space.yizhu.record.template.stat.ast.StatList;

public class If
extends Stat {
    private Expr cond;
    private Stat stat;
    private Stat elseIfOrElse;

    public If(ExprList cond, StatList statList, Location location) {
        if (cond.length() == 0) {
            throw new ParseException("The condition expression of #if statement can not be blank", location);
        }
        this.cond = cond.getActualExpr();
        this.stat = statList.getActualStat();
    }

    @Override
    public void setStat(Stat elseIfOrElse) {
        this.elseIfOrElse = elseIfOrElse;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        if (Logic.isTrue(this.cond.eval(scope))) {
            this.stat.exec(env, scope, writer);
        } else if (this.elseIfOrElse != null) {
            this.elseIfOrElse.exec(env, scope, writer);
        }
    }
}

