/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.stat.ast;

import java.util.List;
import space.yizhu.record.template.Env;
import space.yizhu.record.template.TemplateException;
import space.yizhu.record.template.io.Writer;
import space.yizhu.record.template.stat.Ctrl;
import space.yizhu.record.template.stat.Scope;
import space.yizhu.record.template.stat.ast.NullStat;
import space.yizhu.record.template.stat.ast.Stat;

public class StatList
extends Stat {
    public static final Stat NULL_STAT = NullStat.me;
    public static final Stat[] NULL_STAT_ARRAY = new Stat[0];
    private Stat[] statArray;

    public StatList(List<Stat> statList) {
        this.statArray = statList.size() > 0 ? statList.toArray(new Stat[statList.size()]) : NULL_STAT_ARRAY;
    }

    public Stat getActualStat() {
        if (this.statArray.length > 1) {
            return this;
        }
        if (this.statArray.length == 1) {
            return this.statArray[0];
        }
        return NULL_STAT;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        Ctrl ctrl = scope.getCtrl();
        for (int i = 0; i < this.statArray.length && !ctrl.isJump(); ++i) {
            this.statArray[i].exec(env, scope, writer);
        }
    }

    public int length() {
        return this.statArray.length;
    }

    public Stat getStat(int index) {
        if (index < 0 || index >= this.statArray.length) {
            throw new TemplateException("Index out of bounds: index = " + index + ", length = " + this.statArray.length, this.location);
        }
        return this.statArray[index];
    }
}

