/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.stat.ast;

import java.io.IOException;
import java.nio.charset.Charset;
import space.yizhu.record.template.Env;
import space.yizhu.record.template.TemplateException;
import space.yizhu.record.template.io.IWritable;
import space.yizhu.record.template.io.Writer;
import space.yizhu.record.template.stat.Scope;
import space.yizhu.record.template.stat.ast.Stat;

public class Text
extends Stat
implements IWritable {
    private StringBuilder content;
    private Charset charset;
    private byte[] bytes;
    private char[] chars;

    public Text(StringBuilder content, String encoding) {
        this.content = content;
        this.charset = Charset.forName(encoding);
        this.bytes = null;
        this.chars = null;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        try {
            writer.write(this);
        }
        catch (IOException e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() {
        if (this.bytes != null) {
            return this.bytes;
        }
        Text text = this;
        synchronized (text) {
            if (this.bytes != null) {
                return this.bytes;
            }
            if (this.content != null) {
                this.bytes = this.content.toString().getBytes(this.charset);
                this.content = null;
                return this.bytes;
            }
            this.bytes = new String(this.chars).getBytes(this.charset);
            return this.bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] getChars() {
        if (this.chars != null) {
            return this.chars;
        }
        Text text = this;
        synchronized (text) {
            if (this.chars != null) {
                return this.chars;
            }
            if (this.content != null) {
                char[] charsTemp = new char[this.content.length()];
                this.content.getChars(0, this.content.length(), charsTemp, 0);
                this.chars = charsTemp;
                this.content = null;
                return this.chars;
            }
            String strTemp = new String(this.bytes, this.charset);
            char[] charsTemp = new char[strTemp.length()];
            strTemp.getChars(0, strTemp.length(), charsTemp, 0);
            this.chars = charsTemp;
            return this.chars;
        }
    }

    public boolean isEmpty() {
        if (this.content != null) {
            return this.content.length() == 0;
        }
        if (this.bytes != null) {
            return this.bytes.length == 0;
        }
        return this.chars.length == 0;
    }

    public String toString() {
        if (this.bytes != null) {
            return new String(this.bytes, this.charset);
        }
        if (this.chars != null) {
            return new String(this.chars);
        }
        return this.content.toString();
    }
}

