/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.ocean.annotator.text;

import de.speexx.ocean.annotator.text.AnnotationException;
import de.speexx.ocean.annotator.text.AnnotationHandler;
import de.speexx.ocean.annotator.text.AnnotationHandlerFactoryConfigurationError;
import de.speexx.ocean.annotator.text.DocumentBuilder;
import de.speexx.ocean.annotator.text.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AnnotationHandlerFactory {
    private static final Logger LOG = Logger.getLogger(AnnotationHandlerFactory.class.getName());
    private static final String FACTORY_ID = "META-INF/services/" + AnnotationHandlerFactory.class.getName();

    public static final AnnotationHandlerFactory newInstance() {
        final ClassLoader contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return AnnotationHandlerFactory.getContextClassLoader();
            }
        });
        InputStream in = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LOG.finer(Messages.getString("AnnotationHandlerFactory.1", contextClassLoader));
                if (contextClassLoader != null) {
                    return contextClassLoader.getResourceAsStream(FACTORY_ID);
                }
                return ClassLoader.getSystemResourceAsStream(FACTORY_ID);
            }
        });
        InputStreamReader inReader = null;
        try {
            inReader = new InputStreamReader(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            inReader = new InputStreamReader(in);
        }
        BufferedReader rd = new BufferedReader(inReader);
        try {
            String factoryClassName = rd.readLine();
            AnnotationHandlerFactory factory = AnnotationHandlerFactory.newFactory(factoryClassName, contextClassLoader);
            return factory;
        }
        catch (IOException e) {
            throw new AnnotationHandlerFactoryConfigurationError(Messages.getString("AnnotationHandlerFactory.2"), e);
        }
        catch (RuntimeException e) {
            throw new AnnotationHandlerFactoryConfigurationError(e);
        }
    }

    private static AnnotationHandlerFactory newFactory(final String factoryClass, final ClassLoader classLoader) {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class<?> annotationFactoryClass = null;
                try {
                    block10: {
                        if (classLoader != null) {
                            try {
                                annotationFactoryClass = classLoader.loadClass(factoryClass);
                                return (AnnotationHandlerFactory)annotationFactoryClass.newInstance();
                            }
                            catch (ClassNotFoundException ex) {
                                if (classLoader == (class$de$speexx$ocean$annotator$text$AnnotationHandlerFactory == null ? (class$de$speexx$ocean$annotator$text$AnnotationHandlerFactory = AnnotationHandlerFactory.class$("de.speexx.ocean.annotator.text.AnnotationHandlerFactory")) : class$de$speexx$ocean$annotator$text$AnnotationHandlerFactory).getClassLoader()) {
                                    throw ex;
                                }
                            }
                            catch (NoClassDefFoundError e) {
                                if (classLoader == (class$de$speexx$ocean$annotator$text$AnnotationHandlerFactory == null ? (class$de$speexx$ocean$annotator$text$AnnotationHandlerFactory = AnnotationHandlerFactory.class$("de.speexx.ocean.annotator.text.AnnotationHandlerFactory")) : class$de$speexx$ocean$annotator$text$AnnotationHandlerFactory).getClassLoader()) {
                                    throw e;
                                }
                            }
                            catch (ClassCastException e) {
                                if (classLoader != (class$de$speexx$ocean$annotator$text$AnnotationHandlerFactory == null ? (class$de$speexx$ocean$annotator$text$AnnotationHandlerFactory = AnnotationHandlerFactory.class$("de.speexx.ocean.annotator.text.AnnotationHandlerFactory")) : class$de$speexx$ocean$annotator$text$AnnotationHandlerFactory).getClassLoader()) break block10;
                                throw e;
                            }
                        }
                    }
                    annotationFactoryClass = Class.forName(factoryClass);
                    return (AnnotationHandlerFactory)annotationFactoryClass.newInstance();
                }
                catch (Exception e) {
                    if (annotationFactoryClass != null && !(class$de$speexx$ocean$annotator$text$AnnotationHandlerFactory == null ? (class$de$speexx$ocean$annotator$text$AnnotationHandlerFactory = AnnotationHandlerFactory.class$("de.speexx.ocean.annotator.text.AnnotationHandlerFactory")) : class$de$speexx$ocean$annotator$text$AnnotationHandlerFactory).isAssignableFrom(annotationFactoryClass)) {
                        return new AnnotationHandlerFactoryConfigurationError(Messages.getString("AnnotationHandlerFactory.3"), e);
                    }
                    return new AnnotationHandlerFactoryConfigurationError(e);
                }
            }
        });
        if (result instanceof AnnotationHandlerFactoryConfigurationError) {
            throw (AnnotationHandlerFactoryConfigurationError)result;
        }
        return (AnnotationHandlerFactory)result;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.finer(Messages.getString("AnnotationHandlerFactory.4", Thread.currentThread(), Thread.currentThread().getName(), classLoader));
        }
        return classLoader;
    }

    public abstract AnnotationHandler newAnnotationHandler(Reader var1) throws AnnotationException;

    public abstract DocumentBuilder newDocumentBuilder() throws AnnotationException;
}

