/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.ocean.annotator.text.example;

import de.speexx.ocean.annotator.text.Annotation;
import de.speexx.ocean.annotator.text.AnnotationHandler;
import de.speexx.ocean.annotator.text.AnnotationHandlerFactory;
import de.speexx.ocean.annotator.text.DocumentBuilder;
import de.speexx.ocean.annotator.text.helper.AttributeHelper;
import java.io.StringWriter;
import java.util.logging.Logger;

public final class SimpleDocumentBuilder {
    private static final Logger LOG = Logger.getLogger(SimpleDocumentBuilder.class.getName());
    public static final String SENTENCE_NAMESPACE = "http://www.speexx.de/ocean/ns/example/annotator/sentence#";
    public static final String TITLE_LOCALNAME = "title";

    public String createDocument() throws Exception {
        LOG.info("Start the document creation.");
        AnnotationHandlerFactory factory = AnnotationHandlerFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setGlobalLanguage("en");
        int titleLength = builder.appendText("This is the title!");
        builder.appendText("\n");
        builder.appendText("\n");
        builder.appendText("This is the first sentence. ");
        builder.appendText("The quick brown fox jumps over the lazy dog.");
        AnnotationHandler handler = builder.toAnnotationHandler();
        Annotation a = handler.annotate(0, titleLength, SENTENCE_NAMESPACE, TITLE_LOCALNAME, AttributeHelper.EMPTY);
        LOG.info("Created Annotation: " + a);
        StringWriter writer = new StringWriter();
        handler.serialize(writer);
        String serialized = writer.getBuffer().toString();
        LOG.info("Serialized: " + serialized);
        return serialized;
    }

    public static void main(String[] args) throws Exception {
        new SimpleDocumentBuilder().createDocument();
    }
}

