/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.ocean.annotator.text.example;

import de.speexx.ocean.annotator.text.Annotation;
import de.speexx.ocean.annotator.text.AnnotationHandler;
import de.speexx.ocean.annotator.text.AnnotationHandlerFactory;
import de.speexx.ocean.annotator.text.example.SimpleDocumentBuilder;
import de.speexx.ocean.annotator.text.helper.AttributeHelper;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.logging.Logger;

public final class SimpleSentenceAnnotator {
    private static final Logger LOG = Logger.getLogger(SimpleSentenceAnnotator.class.getName());
    public static final String SENTENCE_LOCALNAME = "sentence";

    public String annotateSentences(String document) throws Exception {
        LOG.info("Start sentence annotation.");
        AnnotationHandlerFactory factory = AnnotationHandlerFactory.newInstance();
        StringReader reader = new StringReader(document);
        AnnotationHandler handler = factory.newAnnotationHandler(reader);
        String language = handler.getGlobalLanguage();
        Locale locale = null;
        if (language != null) {
            locale = new Locale(language);
        }
        BreakIterator boundary = null;
        boundary = locale != null ? BreakIterator.getSentenceInstance(locale) : BreakIterator.getSentenceInstance();
        String text = handler.getText();
        boundary.setText(text);
        int start = boundary.first();
        int end = boundary.next();
        while (end != -1) {
            String s = text.substring(start, end).trim();
            int newSize = s.length();
            Annotation a = handler.annotate(start, start + newSize, "http://www.speexx.de/ocean/ns/example/annotator/sentence#", SENTENCE_LOCALNAME, AttributeHelper.EMPTY);
            LOG.info("Created Annotation: " + a);
            start = end;
            end = boundary.next();
        }
        StringWriter writer = new StringWriter();
        handler.serialize(writer);
        String serialized = writer.getBuffer().toString();
        LOG.info("Serialized: " + serialized);
        return serialized;
    }

    public static void main(String[] args) throws Exception {
        String annotated = new SimpleDocumentBuilder().createDocument();
        new SimpleSentenceAnnotator().annotateSentences(annotated);
    }
}

