/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.ocean.annotator.text.helper;

import de.speexx.ocean.annotator.text.Attribute;
import de.speexx.ocean.annotator.text.IllegalCharacterException;
import de.speexx.ocean.annotator.text.helper.Messages;

public class AttributeHelper
implements Attribute {
    public static final Attribute[] EMPTY = new Attribute[0];
    protected CharSequence value;
    protected String localName;
    protected String namespace;

    public AttributeHelper(String namespace, String localName, CharSequence value) {
        if (localName == null) {
            throw new IllegalArgumentException(Messages.getString("AttributeHelper.0"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(Messages.getString("AttributeHelper.1"));
        }
        this.localName = localName.intern();
        this.namespace = namespace.intern();
        this.value = value;
    }

    public AttributeHelper(String namespace, String localName) {
        this(namespace, localName, null);
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final String getLocalName() {
        return this.localName;
    }

    public final CharSequence getValue() {
        return this.value;
    }

    public void setValue(CharSequence value) throws IllegalCharacterException {
        this.value = value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String clazzName = this.getClass().getName();
        sb.append(clazzName);
        sb.append("[namepace:");
        String tmpPrefix = this.getNamespace();
        sb.append(tmpPrefix);
        sb.append("|localname:");
        String name = this.getLocalName();
        sb.append(name);
        sb.append("|value:");
        CharSequence tmpValue = this.getValue();
        if (tmpValue == null) {
            tmpValue = "<null>";
        } else if (tmpValue.length() > 16) {
            tmpValue = tmpValue.subSequence(0, 16) + "...";
        }
        sb.append((Object)tmpValue);
        sb.append("]");
        return sb.toString();
    }
}

