/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.ocean.annotator.text.internal;

import de.speexx.ocean.annotator.text.Annotation;
import de.speexx.ocean.annotator.text.AnnotationException;
import de.speexx.ocean.annotator.text.Attribute;
import de.speexx.ocean.annotator.text.CorruptStructureException;
import de.speexx.ocean.annotator.text.DuplicateAttributeException;
import de.speexx.ocean.annotator.text.internal.AnnotationHandlerImpl;
import de.speexx.ocean.annotator.text.internal.AttributeImpl;
import de.speexx.ocean.annotator.text.internal.Messages;
import de.speexx.ocean.annotator.text.internal.Version1Serializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

public abstract class AbstractAnnotation
implements Annotation {
    private static final Logger LOG;
    private final int beginIndex;
    private int endIndex;
    private final AnnotationHandlerImpl handler;
    private final Map attributes = new HashMap();
    private final String localName;
    private final String namespace;
    private int weight = 0;
    private String id = "";
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractAnnotation(int beginIndex, int endIndex, String namespace, String localName, int weight, Attribute[] attributes, AnnotationHandlerImpl handler, String id) throws AnnotationException {
        if (handler == null) {
            throw new IllegalArgumentException(Messages.getString("AbstractAnnotation.0"));
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException(Messages.getString("AbstractAnnotation.1", new Integer(beginIndex)));
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(Messages.getString("AbstractAnnotation.2", new Integer(beginIndex), new Integer(endIndex)));
        }
        if (handler.getAnnotationWithId(id) != null) {
            throw new CorruptStructureException(Messages.getString("AbstractAnnotation.12", id, handler.getAnnotationWithId(id)));
        }
        this.handler = handler;
        String text = this.handler.getText();
        int textLength = text.length();
        if (textLength < endIndex) {
            throw new IndexOutOfBoundsException(Messages.getString("AbstractAnnotation.4", new Integer(endIndex), new Integer(textLength)));
        }
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        if (localName == null) {
            throw new IllegalArgumentException(Messages.getString("AbstractAnnotation.6"));
        }
        if (localName.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("AbstractAnnotation.3"));
        }
        this.localName = localName.intern();
        if (namespace == null) {
            throw new IllegalArgumentException(Messages.getString("AbstractAnnotation.7"));
        }
        this.namespace = namespace.intern();
        handler.registerNamespace(this.namespace, null);
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                this.addAttribute0(attributes[i]);
            }
        }
        this.weight = weight;
        this.id = id == null ? AnnotationHandlerImpl.EMPTY_ID : id.intern();
        if (LOG.isLoggable(Level.FINE) && weight < 0 && weight > 100) {
            LOG.fine(Messages.getString("AbstractAnnotation.9", new Integer(0), new Integer(100), this));
        }
    }

    public AbstractAnnotation(int beginIndex, int endIndex, String namespace, String localName, int weight, Attribute[] attributes, AnnotationHandlerImpl handler) throws AnnotationException {
        this(beginIndex, endIndex, namespace, localName, weight, attributes, handler, null);
    }

    public AbstractAnnotation(int beginIndex, int endIndex, String namespace, String localName, Attribute[] attributes, AnnotationHandlerImpl handler) throws AnnotationException {
        this(beginIndex, endIndex, namespace, localName, 100, attributes, handler, null);
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public final int getEndIndex() {
        return this.endIndex;
    }

    public final Iterator iterator() {
        Set attributeKeys = this.attributes.keySet();
        final Object[] keys = attributeKeys.toArray();
        Iterator retval = new Iterator(){
            private int index = -1;
            private boolean removeDone = false;

            public boolean hasNext() {
                if (keys.length == 0) {
                    return false;
                }
                int i = this.index + 1;
                return i < keys.length;
            }

            public void remove() {
                if (keys.length == 0) {
                    throw new IllegalStateException();
                }
                if (this.removeDone) {
                    throw new IllegalStateException();
                }
                AbstractAnnotation.this.attributes.remove(keys[this.index]);
                this.removeDone = true;
            }

            public Object next() {
                if (keys.length == 0) {
                    throw new NoSuchElementException();
                }
                if (this.index < keys.length) {
                    this.removeDone = false;
                    ++this.index;
                    return AbstractAnnotation.this.attributes.get(keys[this.index]);
                }
                throw new NoSuchElementException();
            }
        };
        return retval;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final String getLocalName() {
        return this.localName;
    }

    public final CharSequence getText() {
        String text = this.handler.getText();
        int begin = this.getBeginIndex();
        int end = this.getEndIndex();
        return text.subSequence(begin, end);
    }

    public final void addAttribute(Attribute attribute) throws AnnotationException {
        this.addAttribute0(attribute);
    }

    private void addAttribute0(Attribute attribute) throws AnnotationException {
        if (attribute != null) {
            AttributeImpl clone = new AttributeImpl(attribute, this);
            String key = clone.getNamespace() + Version1Serializer.QNAME_DELIM + clone.getLocalName();
            if (this.attributes.containsKey(key)) {
                String tNamespace = clone.getNamespace();
                String tLocalName = clone.getLocalName();
                throw new DuplicateAttributeException(Messages.getString("AbstractAnnotation.14", tNamespace, tLocalName));
            }
            if (!$assertionsDisabled && key == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && clone == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.attributes == null) {
                throw new AssertionError();
            }
            this.attributes.put(key, clone);
        }
    }

    final AnnotationHandlerImpl getAnnotationHandlerImpl() {
        return this.handler;
    }

    public final int getWeight() {
        return this.weight;
    }

    final String getId() {
        if (!$assertionsDisabled && this.id == null) {
            throw new AssertionError();
        }
        return this.id;
    }

    final void setId(String id) {
        if (id == null) {
            throw new IllegalArgumentException(Messages.getString("AbstractAnnotation.10"));
        }
        this.id = id;
    }

    final void setEndIndex(int newEndIndex) {
        if (this.getBeginIndex() > newEndIndex) {
            throw new IndexOutOfBoundsException(Messages.getString("AbstractAnnotation.2", new Integer(this.beginIndex), new Integer(newEndIndex)));
        }
        this.endIndex = newEndIndex;
    }

    final boolean isNestingByNamespaceAndLocalName(AbstractAnnotation a) {
        if (!$assertionsDisabled && a == null) {
            throw new AssertionError();
        }
        if (this == a) {
            return false;
        }
        if (a.beginIndex < this.beginIndex) {
            return false;
        }
        if (a.endIndex > this.endIndex) {
            return false;
        }
        if (!this.namespace.equals(a.namespace)) {
            return false;
        }
        return this.localName.equals(a.localName);
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        String clazzName = this.getClass().getName();
        sb.append(clazzName);
        sb.append("[beginIndex:");
        sb.append(this.getBeginIndex());
        sb.append("|endIndex:");
        sb.append(this.getEndIndex());
        sb.append("|namespace:");
        sb.append(this.namespace);
        sb.append("|localName:");
        sb.append(this.localName);
        sb.append("|weight:");
        sb.append(this.weight);
        sb.append("|id:");
        sb.append(this.id);
        sb.append("|attributes[");
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            sb.append("[");
            Object o = itr.next();
            sb.append(o);
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    static final AbstractAnnotation createCloneWithNestedNamespace(AbstractAnnotation annotation, int count) throws SAXException {
        StringBuffer sb = new StringBuffer(AnnotationHandlerImpl.ANNOTATION_NS_URI);
        sb.append(Integer.toString(count, 36));
        sb.append("#");
        String namespace = annotation.getNamespace();
        sb.append(namespace);
        String newNamespace = sb.toString();
        int beginIndex = annotation.getBeginIndex();
        int endIndex = annotation.getEndIndex();
        String localName = annotation.getLocalName();
        int weight = annotation.getWeight();
        AnnotationHandlerImpl handler = annotation.getAnnotationHandlerImpl();
        ArrayList attributeList = new ArrayList();
        Iterator itr = annotation.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            attributeList.add(o);
        }
        int size = attributeList.size();
        Attribute[] attrs = attributeList.toArray(new Attribute[size]);
        try {
            NestedNamespaceAnnotation aa = new NestedNamespaceAnnotation(beginIndex, endIndex, newNamespace, localName, weight, attrs, handler);
            return aa;
        }
        catch (AnnotationException e) {
            throw new SAXException(e);
        }
    }

    static {
        $assertionsDisabled = !AbstractAnnotation.class.desiredAssertionStatus();
        LOG = Logger.getLogger(AbstractAnnotation.class.getName());
    }

    private static final class NestedNamespaceAnnotation
    extends AbstractAnnotation {
        public NestedNamespaceAnnotation(int beginIndex, int endIndex, String namespace, String localName, int weight, Attribute[] attributes, AnnotationHandlerImpl handler) throws AnnotationException {
            super(beginIndex, endIndex, namespace, localName, weight, attributes, handler);
        }
    }
}

