/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.ocean.annotator.text.internal;

import de.speexx.ocean.annotator.text.Annotation;
import de.speexx.ocean.annotator.text.AnnotationException;
import de.speexx.ocean.annotator.text.AnnotationHandler;
import de.speexx.ocean.annotator.text.Attribute;
import de.speexx.ocean.annotator.text.CorruptStructureException;
import de.speexx.ocean.annotator.text.IllegalCharacterException;
import de.speexx.ocean.annotator.text.helper.AttributeHelper;
import de.speexx.ocean.annotator.text.internal.AnnotationImpl;
import de.speexx.ocean.annotator.text.internal.AttributeImpl;
import de.speexx.ocean.annotator.text.internal.Messages;
import de.speexx.ocean.annotator.text.internal.Version1Serializer;
import de.speexx.ocean.annotator.text.internal.XmlCharacterValidator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class AnnotationHandlerImpl
implements AnnotationHandler {
    private static final Logger LOG;
    private static final Logger LOG_V1H;
    static final int VALID_POSITION = -1;
    static final int DEFAULT_WEIGHT = 100;
    static final int MIN_WEIGHT = 0;
    static final int ID_RADIX = 36;
    static final String XML_NS_URI = "http://www.w3.org/XML/1998/namespace";
    static final String XML_NS_PREFIX;
    static final String XML_LANG;
    static final String XML_SPACE;
    static final String XML_SPACE_PRESERVE;
    public static final String ANNOTATION_NS_URI;
    public static final String ANNOTATION_DEFAULT_PREFIX;
    public static final String ANNOTATION_ELEMENT_ROOT;
    public static final String ANNOTATION_ELEMENT_TEXT;
    static final String ANNOTATION_ELEMENT_META;
    static final String ANNOTATION_ELEMENT_PROPERTY;
    public static final String ANNOTATION_ATTRIBUTE_KEY;
    public static final String ANNOTATION_ATTRIBUTE_VALUE;
    public static final String ANNOTATION_ATTRIBUT_VERSION;
    public static final String ANNOTATION_ATTRIBUTE_ID;
    public static final String ANNOTATION_ATTRIBUTE_SOURCE;
    public static final String ANNOTATION_ATTRIBUTE_MIMETYPE;
    public static final String ANNOTATION_ATTRIBUTE_IDREF;
    public static final String ANNOTATION_ATTRIBUTE_WEIGHT;
    static final String EMPTY_ID;
    static final String XML_INDENT_VALUE;
    private final List annotations = new ArrayList();
    private String formatVersion = "1".intern();
    private String xmlLang = "".intern();
    private String sourceUri;
    private String sourceMime;
    static final String NUMBER_SIGN = "#";
    private final Map namespaces = new HashMap();
    private String text = "".intern();
    private int prefixCounter = 0;
    private static final InputSource INPUT_SOURCE;
    private Map properties = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public AnnotationHandlerImpl() {
        this.namespaces.put(XML_NS_URI, XML_NS_PREFIX);
    }

    public String getText() {
        return this.text;
    }

    public final Annotation annotate(int beginIndex, int endIndex, String namespace, String localName) throws AnnotationException {
        return this.annotate(beginIndex, endIndex, namespace, localName, 100);
    }

    public final Annotation annotate(int beginIndex, int endIndex, String namespace, String localName, int weight) throws AnnotationException {
        return this.annotate(beginIndex, endIndex, namespace, localName, weight, AttributeHelper.EMPTY);
    }

    public final Annotation annotate(int beginIndex, int endIndex, String namespace, String localName, Attribute[] attributes) throws AnnotationException {
        return this.annotate(beginIndex, endIndex, namespace, localName, 100, attributes);
    }

    public final Annotation annotate(int beginIndex, int endIndex, String namespace, String localName, int weight, Attribute[] attributes) throws AnnotationException {
        AnnotationImpl annotation = new AnnotationImpl(beginIndex, endIndex, namespace, localName, weight, attributes, this, EMPTY_ID);
        this.addAnnotation(annotation);
        return annotation;
    }

    private void addAnnotation(AnnotationImpl annotation) {
        if (!$assertionsDisabled && annotation == null) {
            throw new AssertionError();
        }
        if (this.annotations.contains(annotation)) {
            return;
        }
        this.annotations.add(annotation);
    }

    final void registerNamespace(String namespace, String prefix) {
        if (this.isNamespaceRegistered(namespace)) {
            return;
        }
        if (namespace == null) {
            throw new IllegalArgumentException(Messages.getString("AnnotationHandlerImpl.0"));
        }
        if (namespace.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("AnnotationHandlerImpl.2"));
        }
        String np = this.createPrefix(prefix);
        if (this.namespaces.containsValue(np)) {
            String newPrefix = np + "_";
            this.registerNamespace(namespace.intern(), newPrefix.intern());
        } else {
            this.namespaces.put(namespace.intern(), np.intern());
        }
    }

    final String createPrefix(String prefix) {
        if (prefix != null && prefix.length() != 0) {
            return prefix;
        }
        ++this.prefixCounter;
        return ANNOTATION_DEFAULT_PREFIX + Integer.toString(this.prefixCounter, 36);
    }

    final void cleanUpNamespaces() {
        HashSet<String> n = new HashSet<String>();
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            Annotation a = (Annotation)itr.next();
            String s = a.getNamespace();
            n.add(s);
            Iterator inner = a.iterator();
            while (inner.hasNext()) {
                Attribute attr = (Attribute)inner.next();
                String si = attr.getNamespace();
                n.add(si);
            }
        }
        itr = this.namespaces.keySet().iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (ANNOTATION_NS_URI.equals(o) || XML_NS_URI.equals(o) || n.contains(o)) continue;
            itr.remove();
        }
    }

    boolean isNamespaceRegistered(String namespace) {
        return this.namespaces.containsKey(namespace);
    }

    final String getNamespacePrefix(String namespace) {
        return (String)this.namespaces.get(namespace);
    }

    final String[] namespaces() {
        Set spaces = this.namespaces.keySet();
        int size = spaces.size();
        String[] retval = new String[size];
        return spaces.toArray(retval);
    }

    public final void serialize(Writer writer) throws AnnotationException, IOException {
        this.cleanUpNamespaces();
        Version1Serializer serializer = new Version1Serializer();
        serializer.setAnnotationHandlerImpl(this);
        SAXSource source = new SAXSource((XMLReader)((Object)serializer), INPUT_SOURCE);
        StreamResult result = new StreamResult(writer);
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            if (!factory.getFeature("http://javax.xml.transform.sax.SAXSource/feature")) {
                throw new UnsupportedOperationException(Messages.getString("AnnotationHandlerImpl.8"));
            }
            if (!factory.getFeature("http://javax.xml.transform.stream.StreamResult/feature")) {
                throw new UnsupportedOperationException(Messages.getString("AnnotationHandlerImpl.9"));
            }
            transformer.setOutputProperty("indent", XML_INDENT_VALUE);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new AnnotationException(Messages.getString("AnnotationHandlerImpl.5"), e);
        }
        catch (TransformerException e) {
            throw new AnnotationException(Messages.getString("AnnotationHandlerImpl.6"), e);
        }
    }

    public final Iterator iterator() {
        return this.annotations.iterator();
    }

    final boolean hasPrefixRegisteredNamespace(String prefix) {
        if (prefix == null) {
            return false;
        }
        String[] namespace = this.namespaces();
        for (int i = 0; i < namespace.length; ++i) {
            String localPrefix = this.getNamespacePrefix(namespace[i]);
            if (localPrefix == null || !localPrefix.equals(prefix)) continue;
            return true;
        }
        return false;
    }

    public final String getGlobalLanguage() {
        return this.xmlLang;
    }

    public final void setGlobalLanguage(String globalLanguage) throws IllegalCharacterException {
        if (globalLanguage != null) {
            AnnotationHandlerImpl.checkForXmlChar(globalLanguage);
        }
        this.xmlLang = globalLanguage;
    }

    public final String getSourceUri() {
        return this.sourceUri;
    }

    public final String getSourceMimetype() {
        return this.sourceMime;
    }

    final String getFormatVersion() {
        return this.formatVersion;
    }

    final void init(String text, String sourceUri, String mimetype, String globalLanguage) {
        if (text == null) {
            throw new IllegalArgumentException(Messages.getString("AnnotationHandlerImpl.7"));
        }
        if (!$assertionsDisabled && text == null) {
            throw new AssertionError();
        }
        this.text = text;
        this.sourceMime = mimetype;
        this.sourceUri = sourceUri;
        this.xmlLang = globalLanguage;
    }

    final void init(Reader source) throws IOException, AnnotationException {
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        InputSource input = new InputSource(source);
        AnnotationVersion1SaxHandler handler = this.createAnnotationVersion1SaxHandler();
        try {
            SAXParser parser = factory.newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            handler.setXmlReader(xmlReader);
            parser.parse(input, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new AnnotationException(e);
        }
        catch (SAXException e) {
            Throwable t = e.getCause();
            if (t instanceof AnnotationException) {
                throw (AnnotationException)t;
            }
            throw new AnnotationException(e);
        }
    }

    final AnnotationVersion1SaxHandler createAnnotationVersion1SaxHandler() {
        return new AnnotationVersion1SaxHandler();
    }

    final AnnotationImpl getAnnotationWithId(String annotationId) {
        if (annotationId == null) {
            return null;
        }
        if (EMPTY_ID.equals(annotationId)) {
            return null;
        }
        Iterator itr = this.annotations.iterator();
        while (itr.hasNext()) {
            AnnotationImpl annotation = (AnnotationImpl)itr.next();
            String tmpId = annotation.getId();
            if (!annotationId.equals(tmpId)) continue;
            return annotation;
        }
        return null;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        String clazzName = this.getClass().getName();
        sb.append(clazzName);
        sb.append("[globalLanguage:");
        if (this.xmlLang != null) {
            sb.append(this.xmlLang);
        } else {
            sb.append("<null>");
        }
        sb.append("|sourceUri:");
        if (this.sourceUri != null) {
            sb.append(this.sourceUri);
        } else {
            sb.append("<null>");
        }
        sb.append("|sourceMimetype:");
        if (this.sourceMime != null) {
            sb.append(this.sourceMime);
        } else {
            sb.append("<null>");
        }
        sb.append("|formatVersion:");
        sb.append(this.formatVersion);
        sb.append("|textLength:");
        sb.append(this.getText().length());
        sb.append("|annotationCount:");
        sb.append(this.annotations.size());
        sb.append("|namespaces:[");
        String[] ns = this.namespaces();
        for (int i = 0; i < ns.length; ++i) {
            String prefix = this.getNamespacePrefix(ns[i]);
            sb.append(ns[i]);
            sb.append(":");
            sb.append(prefix);
            sb.append("|");
        }
        int length = sb.length() - 1;
        sb.deleteCharAt(length);
        sb.append("]]");
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final void checkForXmlNcName(String name) throws IllegalCharacterException {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (XmlCharacterValidator.isNcName(name)) return;
        StringReader sr = new StringReader(name);
        BufferedReader br = new BufferedReader(sr);
        String line = null;
        int lineCount = -1;
        try {
            try {
                while ((line = br.readLine()) != null) {
                    ++lineCount;
                    int column = -1;
                    column = AnnotationHandlerImpl.checkForXmlNcChar(line);
                    if (column == -1) continue;
                    throw new IllegalCharacterException(lineCount, column, Messages.getString("AnnotationHandlerImpl.11", new Integer(lineCount), new Integer(column), Integer.toHexString(line.charAt(column))));
                }
                Object var7_7 = null;
            }
            catch (IOException e) {
                throw new AssertionError((Object)Messages.getString("AnnotationHandlerImpl.10"));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                br.close();
            }
            catch (IOException e) {
                throw new AssertionError((Object)Messages.getString("AnnotationHandlerImpl.10"));
            }
            sr.close();
            throw throwable;
        }
        try {}
        catch (IOException e) {
            throw new AssertionError((Object)Messages.getString("AnnotationHandlerImpl.10"));
        }
        br.close();
        sr.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final void checkForXmlChar(String name) throws IllegalCharacterException {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (AnnotationHandlerImpl.checkForXmlChar(name.toCharArray()) == -1) return;
        StringReader sr = new StringReader(name);
        BufferedReader br = new BufferedReader(sr);
        String line = null;
        int lineCount = -1;
        try {
            try {
                while ((line = br.readLine()) != null) {
                    ++lineCount;
                    int column = -1;
                    column = AnnotationHandlerImpl.checkForXmlNcChar(line);
                    if (column == -1) continue;
                    throw new IllegalCharacterException(lineCount, column, Messages.getString("AnnotationHandlerImpl.11", new Integer(lineCount), new Integer(column), Integer.toHexString(line.charAt(column))));
                }
                Object var7_7 = null;
            }
            catch (IOException e) {
                throw new AssertionError((Object)Messages.getString("AnnotationHandlerImpl.10"));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                br.close();
            }
            catch (IOException e) {
                throw new AssertionError((Object)Messages.getString("AnnotationHandlerImpl.10"));
            }
            sr.close();
            throw throwable;
        }
        try {}
        catch (IOException e) {
            throw new AssertionError((Object)Messages.getString("AnnotationHandlerImpl.10"));
        }
        br.close();
        sr.close();
    }

    static final int checkForXmlChar(char[] c) {
        if (!$assertionsDisabled && c == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < c.length; ++i) {
            if (XmlCharacterValidator.isChar(c[i])) continue;
            return i;
        }
        return -1;
    }

    static final int checkForXmlNcChar(String toCheck) {
        if (!$assertionsDisabled && toCheck == null) {
            throw new AssertionError();
        }
        char[] c = toCheck.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (XmlCharacterValidator.isNcNameChar(c[i])) continue;
            return i;
        }
        return -1;
    }

    static final void legalNamespaceTest(String namespaceToCheck) throws AnnotationException {
        if (namespaceToCheck.startsWith(ANNOTATION_NS_URI) || namespaceToCheck.equals(XML_NS_URI)) {
            throw new AnnotationException(Messages.getString("AnnotationImpl.16", namespaceToCheck));
        }
    }

    public String setProperty(String key, String value) throws AnnotationException {
        if (key == null) {
            throw new IllegalArgumentException(Messages.getString("AnnotationHandlerImpl.12"));
        }
        if (value == null) {
            throw new IllegalArgumentException(Messages.getString("AnnotationHandlerImpl.13"));
        }
        AnnotationHandlerImpl.checkForXmlChar(key);
        AnnotationHandlerImpl.checkForXmlChar(value);
        String oldValue = (String)this.properties.get(key);
        this.properties.put(key, value);
        return oldValue;
    }

    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }

    public String removeProperty(String key) {
        return (String)this.properties.remove(key);
    }

    public String[] propertyNames() {
        Set keys = this.properties.keySet();
        int size = keys.size();
        String[] names = new String[size];
        return keys.toArray(names);
    }

    static {
        $assertionsDisabled = !AnnotationHandlerImpl.class.desiredAssertionStatus();
        LOG = Logger.getLogger(AnnotationHandlerImpl.class.getName());
        LOG_V1H = Logger.getLogger(AnnotationVersion1SaxHandler.class.getName());
        XML_NS_PREFIX = "xml".intern();
        XML_LANG = "lang".intern();
        XML_SPACE = "space".intern();
        XML_SPACE_PRESERVE = "preserve".intern();
        ANNOTATION_NS_URI = "http://www.speexx.de/ocean/ns/annotation/1.0/#".intern();
        ANNOTATION_DEFAULT_PREFIX = "a".intern();
        ANNOTATION_ELEMENT_ROOT = "annotation".intern();
        ANNOTATION_ELEMENT_TEXT = "text".intern();
        ANNOTATION_ELEMENT_META = "meta".intern();
        ANNOTATION_ELEMENT_PROPERTY = "property".intern();
        ANNOTATION_ATTRIBUTE_KEY = "key".intern();
        ANNOTATION_ATTRIBUTE_VALUE = "value".intern();
        ANNOTATION_ATTRIBUT_VERSION = "version".intern();
        ANNOTATION_ATTRIBUTE_ID = "id".intern();
        ANNOTATION_ATTRIBUTE_SOURCE = "source".intern();
        ANNOTATION_ATTRIBUTE_MIMETYPE = "mimetype".intern();
        ANNOTATION_ATTRIBUTE_IDREF = "ref".intern();
        ANNOTATION_ATTRIBUTE_WEIGHT = "weight".intern();
        EMPTY_ID = "".intern();
        XML_INDENT_VALUE = "no".intern();
        INPUT_SOURCE = new InputSource();
    }

    final class AnnotationVersion1SaxHandler
    extends DefaultHandler {
        private XMLReader xmlReader;
        private final Stack tmpAnnotations = new Stack();
        private boolean inTextElement = false;
        private final Map namespaceMap = new HashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        AnnotationVersion1SaxHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inTextElement) {
                AnnotationHandlerImpl.this.text = AnnotationHandlerImpl.this.text.toString() + new String(ch, start, length);
                Iterator itr = this.tmpAnnotations.iterator();
                while (itr.hasNext()) {
                    AnnotationImpl annotation = (AnnotationImpl)itr.next();
                    int endIndex = annotation.getEndIndex() + length;
                    annotation.setEndIndex(endIndex);
                }
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.inTextElement) {
                LOG_V1H.warning(Messages.getString("AnnotationVersion1SaxHandler.12"));
                this.characters(ch, start, length);
            }
        }

        public void endDocument() throws SAXException {
            if (LOG.isLoggable(Level.FINER)) {
                int textLength = AnnotationHandlerImpl.this.text.length();
                int annotationSize = AnnotationHandlerImpl.this.annotations.size();
                int namespaceSize = AnnotationHandlerImpl.this.namespaces.size();
                LOG_V1H.finer(Messages.getString("AnnotationVersion1SaxHandler.1", new Integer(textLength), new Integer(annotationSize), new Integer(namespaceSize)));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (ANNOTATION_NS_URI.equals(uri) && ANNOTATION_ELEMENT_TEXT.equals(localName)) {
                this.inTextElement = false;
            }
            if (!this.tmpAnnotations.isEmpty()) {
                AnnotationImpl annotation = (AnnotationImpl)this.tmpAnnotations.pop();
                AnnotationHandlerImpl.this.addAnnotation(annotation);
            }
        }

        public void startDocument() throws SAXException {
            LOG_V1H.finer(Messages.getString("AnnotationVersion1SaxHandler.2"));
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (LOG.isLoggable(Level.FINER)) {
                this.doLogStartElement(uri, localName, qName, attributes);
            }
            if (ANNOTATION_NS_URI.equals(uri) && ANNOTATION_ELEMENT_ROOT.equals(localName)) {
                this.handleStartElement(attributes);
            } else if (ANNOTATION_NS_URI.equals(uri) && ANNOTATION_ELEMENT_META.equals(localName)) {
                if (!$assertionsDisabled && this.xmlReader == null) {
                    throw new AssertionError();
                }
                AnnotationVersion1MetaSaxHandler handler = new AnnotationVersion1MetaSaxHandler(this, this.xmlReader);
                this.xmlReader.setContentHandler(handler);
                this.xmlReader.setDTDHandler(handler);
                this.xmlReader.setEntityResolver(handler);
                this.xmlReader.setErrorHandler(handler);
            } else if (ANNOTATION_NS_URI.equals(uri) && ANNOTATION_ELEMENT_TEXT.equals(localName)) {
                this.inTextElement = true;
            } else if (this.inTextElement) {
                this.handleAnnotationElement(uri, localName, attributes);
            }
        }

        private void handleAnnotationElement(String uri, String localName, Attributes attributes) throws SAXException {
            if (!$assertionsDisabled && uri == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && localName == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && attributes == null) {
                throw new AssertionError();
            }
            int beginIndex = AnnotationHandlerImpl.this.text.length();
            int endIndex = AnnotationHandlerImpl.this.text.length();
            int attributesLength = attributes.getLength();
            ArrayList<AttributeImpl> attributesList = new ArrayList<AttributeImpl>();
            int innerWeight = 100;
            String localId = EMPTY_ID;
            for (int i = 0; i < attributesLength; ++i) {
                String attrLocalName = attributes.getLocalName(i);
                String attrUri = attributes.getURI(i);
                String attrValue = attributes.getValue(i);
                if (ANNOTATION_NS_URI.equals(attrUri) && ANNOTATION_ATTRIBUTE_WEIGHT.equals(attrLocalName)) {
                    try {
                        innerWeight = Integer.parseInt(attrValue);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        CorruptStructureException e2 = new CorruptStructureException(Messages.getString("AnnotationVersion1SaxHandler.5", attrValue), e);
                        throw new SAXException(e2);
                    }
                }
                if (ANNOTATION_NS_URI.equals(attrUri) && ANNOTATION_ATTRIBUTE_ID.equals(attrLocalName)) {
                    if (this.containsLocalAnnotationListId(attrValue)) {
                        CorruptStructureException e = new CorruptStructureException(Messages.getString("AnnotationVersion1SaxHandler.6", attrValue));
                        throw new SAXException(e);
                    }
                    localId = attrValue;
                    continue;
                }
                if (ANNOTATION_NS_URI.equals(attrUri) && ANNOTATION_ATTRIBUTE_IDREF.equals(attrLocalName)) {
                    if (this.containsLocalAnnotationListId(attrValue)) continue;
                    AnnotationImpl annotation = AnnotationHandlerImpl.this.getAnnotationWithId(attrValue);
                    if (annotation == null) {
                        CorruptStructureException e = new CorruptStructureException(Messages.getString("AnnotationVersion1SaxHandler.7", attrValue));
                        throw new SAXException(e);
                    }
                    this.tmpAnnotations.push(annotation);
                    if (attributesList.size() != 0) {
                        LOG_V1H.warning(Messages.getString("AnnotationVersion1SaxHandler.10"));
                    }
                    return;
                }
                try {
                    AttributeImpl localAttribute = new AttributeImpl(attrUri, attrLocalName, attrValue);
                    LOG_V1H.finest(Messages.getString("AnnotationVersion1SaxHandler.8", localAttribute));
                    attributesList.add(localAttribute);
                    continue;
                }
                catch (AnnotationException e) {
                    throw new SAXException(e);
                }
            }
            try {
                int size = attributesList.size();
                Attribute[] annotationAttributes = new AttributeImpl[size];
                String correctedUri = this.checkForNestedNamespace(uri);
                AnnotationImpl annotation = new AnnotationImpl(beginIndex, endIndex, uri == null ? uri : correctedUri, localName, innerWeight, annotationAttributes, AnnotationHandlerImpl.this, localId);
                Iterator itr = attributesList.iterator();
                while (itr.hasNext()) {
                    AttributeImpl localAttr = (AttributeImpl)itr.next();
                    localAttr.setAnnotationImpl(annotation);
                    annotation.addAttribute(localAttr);
                }
                LOG_V1H.finest(Messages.getString("AnnotationVersion1SaxHandler.9", annotation));
                this.tmpAnnotations.push(annotation);
            }
            catch (AnnotationException e) {
                throw new SAXException(e);
            }
        }

        private boolean containsLocalAnnotationListId(String annotationId) {
            if (annotationId == null) {
                return false;
            }
            Iterator itr = this.tmpAnnotations.iterator();
            while (itr.hasNext()) {
                AnnotationImpl annotation = (AnnotationImpl)itr.next();
                String tmpId = annotation.getId();
                if (!annotationId.equals(tmpId)) continue;
                return true;
            }
            return false;
        }

        private void handleStartElement(Attributes attributes) throws SAXException {
            if (!$assertionsDisabled && attributes == null) {
                throw new AssertionError();
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String namespace = attributes.getURI(i);
                String localName = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                if (AnnotationHandlerImpl.XML_NS_URI.equals(namespace) && XML_LANG.equals(localName)) {
                    AnnotationHandlerImpl.this.xmlLang = value;
                    continue;
                }
                if (ANNOTATION_NS_URI.equals(namespace) && ANNOTATION_ATTRIBUT_VERSION.equals(localName)) {
                    AnnotationHandlerImpl.this.formatVersion = value;
                    continue;
                }
                if (ANNOTATION_NS_URI.equals(namespace) && ANNOTATION_ATTRIBUTE_MIMETYPE.equals(localName)) {
                    AnnotationHandlerImpl.this.sourceMime = value;
                    continue;
                }
                if (!ANNOTATION_NS_URI.equals(namespace) || !ANNOTATION_ATTRIBUTE_SOURCE.equals(localName)) continue;
                AnnotationHandlerImpl.this.sourceUri = value;
            }
        }

        private void doLogStartElement(String uri, String localName, String qName, Attributes attributes) {
            LOG_V1H.finer(Messages.getString("AnnotationVersion1SaxHandler.3", uri, localName, qName, attributes));
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (!$assertionsDisabled && prefix == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && uri == null) {
                throw new AssertionError();
            }
            try {
                String original = this.checkForNestedNamespace(uri);
                if (uri.equals(original)) {
                    AnnotationHandlerImpl.this.registerNamespace(uri, null);
                } else {
                    AnnotationHandlerImpl.this.registerNamespace(original, null);
                }
                if (original == null) {
                    this.namespaceMap.put(uri, uri);
                } else {
                    this.namespaceMap.put(uri, original);
                }
            }
            catch (AnnotationException e) {
                throw new SAXException(e);
            }
            LOG_V1H.finer(Messages.getString("AnnotationVersion1SaxHandler.4", uri, prefix));
        }

        String checkForNestedNamespace(String namespace) throws AnnotationException {
            if (namespace == null) {
                return null;
            }
            if (!namespace.startsWith(ANNOTATION_NS_URI)) {
                return namespace;
            }
            if (ANNOTATION_NS_URI.equals(namespace)) {
                return namespace;
            }
            String originalPartStart = namespace.substring(ANNOTATION_NS_URI.length());
            int firstNumberSignIndex = originalPartStart.indexOf(AnnotationHandlerImpl.NUMBER_SIGN);
            if (firstNumberSignIndex <= -1) {
                throw new CorruptStructureException(Messages.getString("AnnotationVersion1SaxHandler.11", namespace));
            }
            if (originalPartStart.length() <= firstNumberSignIndex + 1) {
                throw new CorruptStructureException(Messages.getString("AnnotationVersion1SaxHandler.11", namespace));
            }
            return originalPartStart.substring(firstNumberSignIndex + 1);
        }

        public void setXmlReader(XMLReader xmlReader) {
            this.xmlReader = xmlReader;
        }

        public XMLReader getXmlReader() {
            return this.xmlReader;
        }

        static {
            $assertionsDisabled = !(class$de$speexx$ocean$annotator$text$internal$AnnotationHandlerImpl == null ? (class$de$speexx$ocean$annotator$text$internal$AnnotationHandlerImpl = AnnotationHandlerImpl.class$("de.speexx.ocean.annotator.text.internal.AnnotationHandlerImpl")) : class$de$speexx$ocean$annotator$text$internal$AnnotationHandlerImpl).desiredAssertionStatus();
        }
    }

    private final class AnnotationVersion1MetaSaxHandler
    extends DefaultHandler {
        private final DefaultHandler handler;
        private final XMLReader xmlReader;

        public AnnotationVersion1MetaSaxHandler(DefaultHandler handler, XMLReader xmlReader) {
            if (handler == null) {
                throw new IllegalArgumentException(Messages.getString("AnnotationVersion1MetaSaxHandler.1"));
            }
            if (xmlReader == null) {
                throw new IllegalArgumentException(Messages.getString("AnnotationVersion1MetaSaxHandler.2"));
            }
            this.handler = handler;
            this.xmlReader = xmlReader;
        }

        public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
            if (ANNOTATION_NS_URI.equals(uri) && ANNOTATION_ELEMENT_PROPERTY.equals(localName)) {
                String key = attr.getValue(ANNOTATION_NS_URI, ANNOTATION_ATTRIBUTE_KEY);
                String value = attr.getValue(ANNOTATION_NS_URI, ANNOTATION_ATTRIBUTE_VALUE);
                try {
                    AnnotationHandlerImpl.this.setProperty(key, value);
                }
                catch (AnnotationException e) {
                    String message = e.getMessage();
                    throw new AssertionError((Object)message);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (ANNOTATION_NS_URI.equals(uri) && ANNOTATION_ELEMENT_META.equals(localName)) {
                this.xmlReader.setContentHandler(this.handler);
                this.xmlReader.setDTDHandler(this.handler);
                this.xmlReader.setEntityResolver(this.handler);
                this.xmlReader.setErrorHandler(this.handler);
            }
        }
    }
}

