/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.ocean.annotator.text.internal;

import de.speexx.ocean.annotator.text.AnnotationException;
import de.speexx.ocean.annotator.text.Attribute;
import de.speexx.ocean.annotator.text.IllegalCharacterException;
import de.speexx.ocean.annotator.text.helper.AttributeHelper;
import de.speexx.ocean.annotator.text.internal.AbstractAnnotation;
import de.speexx.ocean.annotator.text.internal.AnnotationHandlerImpl;
import de.speexx.ocean.annotator.text.internal.AnnotationImpl;
import de.speexx.ocean.annotator.text.internal.Messages;
import org.w3c.dom.Attr;

public class AttributeImpl
extends AttributeHelper {
    private AbstractAnnotation annotation;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AttributeImpl(Attr domAttribute, AnnotationImpl annotation) throws AnnotationException {
        this(domAttribute.getNamespaceURI(), domAttribute.getLocalName(), domAttribute.getValue(), annotation);
    }

    public AttributeImpl(String namespace, String localName, CharSequence value, AbstractAnnotation annotation) throws AnnotationException {
        super(namespace, localName, value);
        if (annotation == null) {
            throw new IllegalArgumentException(Messages.getString("AttributeImpl.0"));
        }
        AnnotationHandlerImpl.checkForXmlNcName(localName);
        AnnotationHandlerImpl.legalNamespaceTest(namespace);
        if (value != null) {
            AnnotationHandlerImpl.checkForXmlChar(((Object)value).toString());
        }
        this.annotation = annotation;
        AnnotationHandlerImpl handler = this.annotation.getAnnotationHandlerImpl();
        handler.registerNamespace(namespace, null);
    }

    public AttributeImpl(String namespace, String localName, CharSequence value) throws AnnotationException {
        super(namespace, localName, value);
        AnnotationHandlerImpl.checkForXmlNcName(localName);
        AnnotationHandlerImpl.legalNamespaceTest(namespace);
        if (value != null) {
            AnnotationHandlerImpl.checkForXmlChar(((Object)value).toString());
        }
    }

    public AttributeImpl(String namespace, String localName, AbstractAnnotation annotation) throws AnnotationException {
        this(namespace, localName, null, annotation);
    }

    public AttributeImpl(Attribute attribute, AbstractAnnotation annotation) throws AnnotationException {
        this(attribute.getNamespace(), attribute.getLocalName(), attribute.getValue(), annotation);
    }

    final AbstractAnnotation getAbstractAnnotation() {
        return this.annotation;
    }

    public final void setValue(CharSequence value) throws IllegalCharacterException {
        if (value != null) {
            AnnotationHandlerImpl.checkForXmlChar(((Object)value).toString());
        }
        super.setValue(value);
    }

    final void setAnnotationImpl(AnnotationImpl annotation) {
        if (!$assertionsDisabled && annotation == null) {
            throw new AssertionError();
        }
        this.annotation = annotation;
    }

    final void clearAnnotation() {
        this.annotation = null;
    }

    public final int hashCode() {
        int hash = 37;
        hash *= this.getNamespace().hashCode();
        hash *= this.getLocalName().hashCode();
        if (this.getValue() != null) {
            hash *= this.getValue().hashCode();
        }
        return hash;
    }

    public final boolean equals(Object obj) {
        CharSequence otherValue;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeImpl other = (AttributeImpl)obj;
        if (!other.getLocalName().equals(this.getLocalName())) {
            return false;
        }
        if (!other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        CharSequence localValue = this.getValue();
        if (localValue == (otherValue = other.getValue())) {
            return true;
        }
        if (localValue != null) {
            return localValue.equals(otherValue);
        }
        if (otherValue != null) {
            return otherValue.equals(localValue);
        }
        return false;
    }

    static {
        $assertionsDisabled = !AttributeImpl.class.desiredAssertionStatus();
    }
}

