/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.ocean.annotator.text.internal;

import de.speexx.ocean.annotator.text.AnnotationHandler;
import de.speexx.ocean.annotator.text.DocumentBuilder;
import de.speexx.ocean.annotator.text.IllegalCharacterException;
import de.speexx.ocean.annotator.text.internal.AnnotationHandlerImpl;
import de.speexx.ocean.annotator.text.internal.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public final class DocumentBuilderImpl
implements DocumentBuilder {
    private String xmlLang = "".intern();
    private String sourceUri;
    private String sourceMime;
    private StringBuffer text = new StringBuffer();

    public int appendText(String append) throws IllegalCharacterException {
        if (append == null) {
            return 0;
        }
        String normalized = DocumentBuilderImpl.normalizeText(append);
        this.text.append(normalized);
        return normalized.length();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String normalizeText(String toNormalize) throws IllegalCharacterException {
        if (toNormalize.length() == 0) {
            return toNormalize;
        }
        StringReader sr = new StringReader(toNormalize);
        BufferedReader br = new BufferedReader(sr);
        int size = toNormalize.length();
        StringBuffer sb = new StringBuffer(size);
        String line = null;
        int lineCount = -1;
        try {
            try {}
            catch (IOException e) {
                throw new AssertionError((Object)Messages.getString("DocumentBuilderImpl.0"));
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                br.close();
            }
            catch (IOException e) {
                throw new AssertionError((Object)Messages.getString("DocumentBuilderImpl.0"));
            }
            sr.close();
            throw throwable;
        }
        while ((line = br.readLine()) != null) {
            ++lineCount;
            char[] lineArray = line.toCharArray();
            int column = AnnotationHandlerImpl.checkForXmlChar(lineArray);
            if (column != -1) {
                throw new IllegalCharacterException(lineCount, column, Messages.getString("DocumentBuilderImpl.1", new Integer(lineCount), new Integer(column), Integer.toHexString(line.charAt(column))));
            }
            sb.append(line);
            sb.append("\n");
        }
        Object var10_11 = null;
        try {}
        catch (IOException e) {
            throw new AssertionError((Object)Messages.getString("DocumentBuilderImpl.0"));
        }
        br.close();
        sr.close();
        char last = toNormalize.charAt(size - 1);
        if (last != '\n' && last != '\r') {
            int nsize = sb.length();
            sb.deleteCharAt(nsize - 1);
        }
        return sb.toString();
    }

    public AnnotationHandler toAnnotationHandler() {
        AnnotationHandlerImpl ah = new AnnotationHandlerImpl();
        ah.init(this.getText(), this.getSourceUri(), this.getSourceMimetype(), this.getGlobalLanguage());
        return ah;
    }

    public String getText() {
        return this.text.toString();
    }

    public String getGlobalLanguage() {
        return this.xmlLang;
    }

    public void setGlobalLanguage(String globalLanguage) throws IllegalCharacterException {
        if (globalLanguage != null) {
            AnnotationHandlerImpl.checkForXmlChar(globalLanguage);
        }
        this.xmlLang = globalLanguage;
    }

    public String getSourceUri() {
        return this.sourceUri;
    }

    public String getSourceMimetype() {
        return this.sourceMime;
    }

    public void setSourceUri(String sourceUri) throws IllegalCharacterException {
        if (sourceUri != null) {
            AnnotationHandlerImpl.checkForXmlChar(sourceUri);
        }
        this.sourceUri = sourceUri;
    }

    public void setSourceMimetype(String mimetype) throws IllegalCharacterException {
        if (mimetype != null) {
            AnnotationHandlerImpl.checkForXmlChar(mimetype);
        }
        this.sourceMime = mimetype;
    }
}

