/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.ocean.annotator.text.internal;

import de.speexx.ocean.annotator.text.internal.AbstractAnnotation;
import de.speexx.ocean.annotator.text.internal.AnnotationHandlerImpl;
import de.speexx.ocean.annotator.text.internal.AttributeImpl;
import de.speexx.ocean.annotator.text.internal.Messages;
import de.speexx.xml.sax.helpers.AbstractXmlReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class Version1Serializer
extends AbstractXmlReader {
    public static final String VERSION;
    static final String QNAME_DELIM;
    static final String XMLNS_PREFIX;
    static final String CDATA;
    static final AnnotationIndexComparator INDEX_COMPARATOR;
    private AnnotationHandlerImpl handler;
    private static final Attributes ATTRS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setAnnotationHandlerImpl(AnnotationHandlerImpl handler) {
        this.handler = handler;
    }

    public AnnotationHandlerImpl getAnnotationHandlerImpl() {
        return this.handler;
    }

    public void parse(InputSource source) throws SAXException {
        AnnotationHandlerImpl ah = this.getAnnotationHandlerImpl();
        if (ah == null) {
            throw new IllegalStateException(Messages.getString("Version1Serializer.0"));
        }
        ContentHandler ch = this.getContentHandler();
        ch.startDocument();
        AbstractAnnotation[] extractedAnnotations = this.extractSortedAnnotationArray(ah);
        AbstractAnnotation[] annotations = this.replaceNestedAnnotationNamespace(extractedAnnotations);
        this.prepareWithIds(annotations);
        this.fireStartPrefixMapping(ah);
        this.fireStartRootElement(ah);
        this.handleProperties(ah);
        this.fireStartTextElement(ah);
        this.handleAnnotations(ah, annotations);
        this.fireEndTextElement(ah);
        this.fireEndRootElement(ah);
        this.fireEndPrefixMapping(ah);
        this.writeFooter();
        ch = this.getContentHandler();
        ch.endDocument();
        ah.cleanUpNamespaces();
    }

    void prepareWithIds(AbstractAnnotation[] a) {
        int ii = 0;
        int i = 0;
        while (i < a.length) {
            String id = Integer.toString(ii, 36);
            a[i].setId(id);
            ++i;
            ++ii;
        }
    }

    void handleAnnotations(AnnotationHandlerImpl ah, AbstractAnnotation[] annotations) throws SAXException {
        if (!$assertionsDisabled && ah == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && annotations == null) {
            throw new AssertionError();
        }
        char[] text = this.getAnnotationHandlerText(ah);
        ArrayList<SerializationHelper> openAnnotations = new ArrayList<SerializationHelper>();
        for (int index = 0; index < text.length; ++index) {
            SerializationHelper helper;
            Object o;
            Iterator itr;
            boolean closed = this.annotationsToClose(index, openAnnotations);
            if (closed) {
                this.closeOpenAnnotations(ah, openAnnotations);
            }
            this.removeAnnotationsToClose(index, openAnnotations);
            List toStart = this.findAnnotationsToStart(index, annotations);
            if (!closed) {
                itr = toStart.iterator();
                while (itr.hasNext()) {
                    o = itr.next();
                    if (!$assertionsDisabled && !(o instanceof SerializationHelper)) {
                        throw new AssertionError();
                    }
                    helper = (SerializationHelper)o;
                    this.fireAnnotationStart(ah, helper);
                    openAnnotations.add(helper);
                }
            } else {
                openAnnotations.addAll(toStart);
                itr = openAnnotations.iterator();
                while (itr.hasNext()) {
                    o = itr.next();
                    if (!$assertionsDisabled && !(o instanceof SerializationHelper)) {
                        throw new AssertionError();
                    }
                    helper = (SerializationHelper)o;
                    this.fireAnnotationStart(ah, helper);
                }
            }
            ContentHandler ch = this.getContentHandler();
            ch.characters(text, index, 1);
        }
        this.closeOpenAnnotations(ah, openAnnotations);
    }

    final AbstractAnnotation[] replaceNestedAnnotationNamespace(AbstractAnnotation[] annotations) throws SAXException {
        if (!$assertionsDisabled && annotations == null) {
            throw new AssertionError();
        }
        int count = 0;
        for (int i = 0; i < annotations.length; ++i) {
            AbstractAnnotation a = annotations[i];
            for (int j = 0; j < annotations.length; ++j) {
                if (!a.isNestingByNamespaceAndLocalName(annotations[j])) continue;
                annotations[j] = AbstractAnnotation.createCloneWithNestedNamespace(annotations[j], count);
                ++count;
            }
        }
        return annotations;
    }

    void fireAnnotationStart(AnnotationHandlerImpl ah, SerializationHelper helper) throws SAXException {
        if (!$assertionsDisabled && ah == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && helper == null) {
            throw new AssertionError();
        }
        AbstractAnnotation a = helper.getAbstractAnnotation();
        Attributes attributes = null;
        attributes = helper.isOutputed() ? this.createIdRefAttribute(ah, a) : this.createFullAttributes(ah, a);
        if (!$assertionsDisabled && attributes == null) {
            throw new AssertionError();
        }
        String localName = a.getLocalName();
        if (!$assertionsDisabled && localName == null) {
            throw new AssertionError();
        }
        String namespace = a.getNamespace();
        if (!$assertionsDisabled && namespace == null) {
            throw new AssertionError();
        }
        String prefix = ah.getNamespacePrefix(namespace);
        if (!$assertionsDisabled && prefix == null) {
            throw new AssertionError();
        }
        ContentHandler ch = this.getContentHandler();
        ch.startElement(namespace, localName, prefix + QNAME_DELIM + localName, attributes);
    }

    Attributes createFullAttributes(AnnotationHandlerImpl ah, AbstractAnnotation a) {
        AttributesImpl impl = new AttributesImpl();
        String prefix = ah.getNamespacePrefix(AnnotationHandlerImpl.ANNOTATION_NS_URI);
        if (!$assertionsDisabled && prefix == null) {
            throw new AssertionError();
        }
        String id = a.getId();
        impl.addAttribute(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_ATTRIBUTE_ID, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ATTRIBUTE_ID, CDATA, id);
        String weight = "" + a.getWeight();
        impl.addAttribute(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_ATTRIBUTE_WEIGHT, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ATTRIBUTE_WEIGHT, CDATA, weight);
        Iterator itr = a.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!$assertionsDisabled && !(o instanceof AttributeImpl)) {
                throw new AssertionError();
            }
            AttributeImpl attr = (AttributeImpl)o;
            String attrNamespace = attr.getNamespace();
            if (!$assertionsDisabled && attrNamespace == null) {
                throw new AssertionError();
            }
            String attrLocalName = attr.getLocalName();
            if (!$assertionsDisabled && attrLocalName == null) {
                throw new AssertionError();
            }
            String attrPrefix = ah.getNamespacePrefix(attrNamespace);
            if (!$assertionsDisabled && attrPrefix == null) {
                throw new AssertionError();
            }
            String attrValue = ((Object)attr.getValue()).toString();
            impl.addAttribute(attrNamespace, attrLocalName, attrPrefix + QNAME_DELIM + attrLocalName, CDATA, attrValue);
        }
        return impl;
    }

    Attributes createIdRefAttribute(AnnotationHandlerImpl ah, AbstractAnnotation a) {
        String id = a.getId();
        AttributesImpl impl = new AttributesImpl();
        String prefix = ah.getNamespacePrefix(AnnotationHandlerImpl.ANNOTATION_NS_URI);
        if (!$assertionsDisabled && prefix == null) {
            throw new AssertionError();
        }
        impl.addAttribute(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_ATTRIBUTE_IDREF, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ATTRIBUTE_IDREF, CDATA, id);
        return impl;
    }

    void closeOpenAnnotations(AnnotationHandlerImpl ah, List openAnnotations) throws SAXException {
        if (!$assertionsDisabled && ah == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && openAnnotations == null) {
            throw new AssertionError();
        }
        Collections.reverse(openAnnotations);
        Iterator itr = openAnnotations.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!$assertionsDisabled && !(o instanceof SerializationHelper)) {
                throw new AssertionError();
            }
            SerializationHelper helper = (SerializationHelper)o;
            AbstractAnnotation impl = helper.getAbstractAnnotation();
            this.fireEndAnnotation(ah, impl);
            helper.setOutputed();
        }
        Collections.reverse(openAnnotations);
    }

    List findAnnotationsToStart(int currentPos, AbstractAnnotation[] annotations) {
        LinkedList<SerializationHelper> toStart = new LinkedList<SerializationHelper>();
        for (int i = 0; i < annotations.length; ++i) {
            if (currentPos != annotations[i].getBeginIndex()) continue;
            SerializationHelper h = new SerializationHelper(annotations[i]);
            toStart.add(h);
        }
        return toStart;
    }

    void fireEndAnnotation(AnnotationHandlerImpl ah, AbstractAnnotation a) throws SAXException {
        if (!$assertionsDisabled && ah == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && a == null) {
            throw new AssertionError();
        }
        String localName = a.getLocalName();
        if (!$assertionsDisabled && localName == null) {
            throw new AssertionError();
        }
        String namespace = a.getNamespace();
        if (!$assertionsDisabled && namespace == null) {
            throw new AssertionError();
        }
        String prefix = ah.getNamespacePrefix(namespace);
        if (!$assertionsDisabled && prefix == null) {
            throw new AssertionError();
        }
        ContentHandler ch = this.getContentHandler();
        ch.endElement(namespace, localName, prefix + QNAME_DELIM + localName);
    }

    boolean annotationsToClose(int currentPos, List openAnnotations) {
        if (!$assertionsDisabled && currentPos < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && openAnnotations == null) {
            throw new AssertionError();
        }
        Iterator itr = openAnnotations.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!$assertionsDisabled && !(o instanceof SerializationHelper)) {
                throw new AssertionError();
            }
            SerializationHelper h = (SerializationHelper)o;
            AbstractAnnotation a = h.getAbstractAnnotation();
            if (currentPos != a.getEndIndex()) continue;
            return true;
        }
        return false;
    }

    List removeAnnotationsToClose(int currentPos, List openAnnotations) {
        if (!$assertionsDisabled && currentPos < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && openAnnotations == null) {
            throw new AssertionError();
        }
        LinkedList<SerializationHelper> retval = new LinkedList<SerializationHelper>();
        Iterator itr = openAnnotations.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!$assertionsDisabled && !(o instanceof SerializationHelper)) {
                throw new AssertionError();
            }
            SerializationHelper h = (SerializationHelper)o;
            AbstractAnnotation a = h.getAbstractAnnotation();
            if (currentPos != a.getEndIndex()) continue;
            itr.remove();
            retval.add(h);
        }
        Collections.reverse(retval);
        return retval;
    }

    char[] getAnnotationHandlerText(AnnotationHandlerImpl ah) {
        if (!$assertionsDisabled && ah == null) {
            throw new AssertionError();
        }
        String text = ah.getText();
        if (!$assertionsDisabled && text == null) {
            throw new AssertionError();
        }
        return text.toCharArray();
    }

    AbstractAnnotation[] extractSortedAnnotationArray(AnnotationHandlerImpl ah) {
        ArrayList annotations = new ArrayList();
        Iterator itr = ah.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            annotations.add(o);
        }
        return this.sortAnnotationList(annotations);
    }

    AbstractAnnotation[] sortAnnotationList(List listOfAnnotations) {
        if (!$assertionsDisabled && listOfAnnotations == null) {
            throw new AssertionError();
        }
        Collections.sort(listOfAnnotations, INDEX_COMPARATOR);
        int annotationSize = listOfAnnotations.size();
        AbstractAnnotation[] array = new AbstractAnnotation[annotationSize];
        return listOfAnnotations.toArray(array);
    }

    void fireStartPrefixMapping(AnnotationHandlerImpl ah) throws SAXException {
        if (!$assertionsDisabled && ah == null) {
            throw new AssertionError();
        }
        if (!ah.isNamespaceRegistered(AnnotationHandlerImpl.ANNOTATION_NS_URI)) {
            ah.registerNamespace(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_DEFAULT_PREFIX);
        }
        String[] namespaces = ah.namespaces();
        for (int i = 0; i < namespaces.length; ++i) {
            if ("http://www.w3.org/XML/1998/namespace".equals(namespaces[i])) continue;
            String prefix = ah.getNamespacePrefix(namespaces[i]);
            ContentHandler ch = this.getContentHandler();
            ch.startPrefixMapping(prefix, namespaces[i]);
        }
    }

    void writeFooter() throws SAXException {
        ContentHandler ch = this.getContentHandler();
        ch.characters(new char[]{'\n'}, 0, 1);
        if (ch instanceof LexicalHandler) {
            String comment = " " + Messages.getString("Version1Serializer.2", Version1Serializer.class.getName(), new Date()) + " ";
            ((LexicalHandler)((Object)ch)).comment(comment.toCharArray(), 0, comment.length());
        }
    }

    void fireEndPrefixMapping(AnnotationHandlerImpl ah) throws SAXException {
        if (!$assertionsDisabled && ah == null) {
            throw new AssertionError();
        }
        String[] namespaces = ah.namespaces();
        for (int i = 0; i < namespaces.length; ++i) {
            if ("http://www.w3.org/XML/1998/namespace".equals(namespaces[i])) continue;
            String prefix = ah.getNamespacePrefix(namespaces[i]);
            ContentHandler ch = this.getContentHandler();
            ch.endPrefixMapping(prefix);
        }
    }

    void fireEndRootElement(AnnotationHandlerImpl ah) throws SAXException {
        if (!$assertionsDisabled && ah == null) {
            throw new AssertionError();
        }
        String prefix = ah.getNamespacePrefix(AnnotationHandlerImpl.ANNOTATION_NS_URI);
        ContentHandler ch = this.getContentHandler();
        ch.endElement(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_ELEMENT_ROOT, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ELEMENT_ROOT);
    }

    void fireEndTextElement(AnnotationHandlerImpl ah) throws SAXException {
        if (!$assertionsDisabled && ah == null) {
            throw new AssertionError();
        }
        String prefix = ah.getNamespacePrefix(AnnotationHandlerImpl.ANNOTATION_NS_URI);
        ContentHandler ch = this.getContentHandler();
        ch.endElement(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_ELEMENT_TEXT, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ELEMENT_TEXT);
    }

    void fireStartRootElement(AnnotationHandlerImpl ah) throws SAXException {
        if (!$assertionsDisabled && ah == null) {
            throw new AssertionError();
        }
        ContentHandler lch = this.getContentHandler();
        Attributes attributes = this.createRootAttributes(ah);
        String prefix = ah.getNamespacePrefix(AnnotationHandlerImpl.ANNOTATION_NS_URI);
        lch.startElement(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_ELEMENT_ROOT, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ELEMENT_ROOT, attributes);
    }

    void fireStartTextElement(AnnotationHandlerImpl ah) throws SAXException {
        if (!$assertionsDisabled && ah == null) {
            throw new AssertionError();
        }
        String prefix = ah.getNamespacePrefix(AnnotationHandlerImpl.ANNOTATION_NS_URI);
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("http://www.w3.org/XML/1998/namespace", AnnotationHandlerImpl.XML_SPACE, ah.getNamespacePrefix("http://www.w3.org/XML/1998/namespace") + QNAME_DELIM + AnnotationHandlerImpl.XML_SPACE, CDATA, AnnotationHandlerImpl.XML_SPACE_PRESERVE);
        ContentHandler ch = this.getContentHandler();
        ch.startElement(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_ELEMENT_TEXT, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ELEMENT_TEXT, attr);
    }

    Attributes createRootAttributes(AnnotationHandlerImpl ah) {
        String lang;
        String source;
        if (!$assertionsDisabled && ah == null) {
            throw new AssertionError();
        }
        AttributesImpl impl = new AttributesImpl();
        String prefix = ah.getNamespacePrefix(AnnotationHandlerImpl.ANNOTATION_NS_URI);
        impl.addAttribute(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_ATTRIBUT_VERSION, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ATTRIBUT_VERSION, CDATA, VERSION);
        String mime = ah.getSourceMimetype();
        if (mime != null) {
            impl.addAttribute(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_ATTRIBUTE_MIMETYPE, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ATTRIBUTE_MIMETYPE, CDATA, mime);
        }
        if ((source = ah.getSourceUri()) != null) {
            impl.addAttribute(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_ATTRIBUTE_SOURCE, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ATTRIBUTE_SOURCE, CDATA, source);
        }
        if ((lang = ah.getGlobalLanguage()) != null) {
            impl.addAttribute("http://www.w3.org/XML/1998/namespace", AnnotationHandlerImpl.XML_LANG, AnnotationHandlerImpl.XML_NS_PREFIX + QNAME_DELIM + AnnotationHandlerImpl.XML_LANG, CDATA, lang);
        }
        String[] namespaces = ah.namespaces();
        for (int i = 0; i < namespaces.length; ++i) {
            if ("http://www.w3.org/XML/1998/namespace".equals(namespaces[i])) continue;
            String nPrefix = ah.getNamespacePrefix(namespaces[i]);
            impl.addAttribute("http://www.w3.org/XML/1998/namespace", nPrefix, XMLNS_PREFIX + QNAME_DELIM + nPrefix, CDATA, namespaces[i]);
        }
        return impl;
    }

    void handleProperties(AnnotationHandlerImpl ah) throws SAXException {
        if (!$assertionsDisabled && ah == null) {
            throw new AssertionError();
        }
        String[] properties = ah.propertyNames();
        if (properties.length == 0) {
            return;
        }
        this.fireStartMetaElement(ah);
        for (int i = 0; i < properties.length; ++i) {
            this.firePropertyElement(ah, properties[i]);
        }
        this.fireEndMetaElement(ah);
    }

    void firePropertyElement(AnnotationHandlerImpl ah, String key) throws SAXException {
        if (!$assertionsDisabled && ah == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        String value = ah.getProperty(key);
        String prefix = ah.getNamespacePrefix(AnnotationHandlerImpl.ANNOTATION_NS_URI);
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("http://www.w3.org/XML/1998/namespace", AnnotationHandlerImpl.ANNOTATION_ATTRIBUTE_KEY, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ATTRIBUTE_KEY, CDATA, key);
        attr.addAttribute("http://www.w3.org/XML/1998/namespace", AnnotationHandlerImpl.ANNOTATION_ATTRIBUTE_VALUE, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ATTRIBUTE_VALUE, CDATA, value);
        ContentHandler ch = this.getContentHandler();
        if (!$assertionsDisabled && ch == null) {
            throw new AssertionError();
        }
        ch.startElement(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_ELEMENT_PROPERTY, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ELEMENT_PROPERTY, attr);
        ch.endElement(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_ELEMENT_PROPERTY, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ELEMENT_PROPERTY);
    }

    void fireStartMetaElement(AnnotationHandlerImpl ah) throws SAXException {
        ContentHandler ch = this.getContentHandler();
        if (!$assertionsDisabled && ch == null) {
            throw new AssertionError();
        }
        String prefix = ah.getNamespacePrefix(AnnotationHandlerImpl.ANNOTATION_NS_URI);
        ch.startElement(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_ELEMENT_META, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ELEMENT_META, ATTRS);
    }

    void fireEndMetaElement(AnnotationHandlerImpl ah) throws SAXException {
        ContentHandler ch = this.getContentHandler();
        if (!$assertionsDisabled && ch == null) {
            throw new AssertionError();
        }
        String prefix = ah.getNamespacePrefix(AnnotationHandlerImpl.ANNOTATION_NS_URI);
        ch.endElement(AnnotationHandlerImpl.ANNOTATION_NS_URI, AnnotationHandlerImpl.ANNOTATION_ELEMENT_META, prefix + QNAME_DELIM + AnnotationHandlerImpl.ANNOTATION_ELEMENT_META);
    }

    static {
        $assertionsDisabled = !Version1Serializer.class.desiredAssertionStatus();
        VERSION = "1".intern();
        QNAME_DELIM = ":".intern();
        XMLNS_PREFIX = "xmlns".intern();
        CDATA = "CDATA".intern();
        INDEX_COMPARATOR = new AnnotationIndexComparator();
        ATTRS = new AttributesImpl();
    }

    static final class AnnotationIndexComparator
    implements Comparator {
        static final /* synthetic */ boolean $assertionsDisabled;

        AnnotationIndexComparator() {
        }

        public int compare(Object a1, Object a2) {
            int ai2End;
            int ai2Begin;
            if (!$assertionsDisabled && a1 == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && a2 == null) {
                throw new AssertionError();
            }
            AbstractAnnotation ai1 = (AbstractAnnotation)a1;
            AbstractAnnotation ai2 = (AbstractAnnotation)a2;
            int ai1Begin = ai1.getBeginIndex();
            if (ai1Begin < (ai2Begin = ai2.getBeginIndex())) {
                return -1;
            }
            if (ai1Begin > ai2Begin) {
                return 1;
            }
            int ai1End = ai1.getEndIndex();
            if (ai1End < (ai2End = ai2.getEndIndex())) {
                return -1;
            }
            if (ai1End > ai2End) {
                return 1;
            }
            return 0;
        }

        static {
            $assertionsDisabled = !(class$de$speexx$ocean$annotator$text$internal$Version1Serializer == null ? (class$de$speexx$ocean$annotator$text$internal$Version1Serializer = Version1Serializer.class$("de.speexx.ocean.annotator.text.internal.Version1Serializer")) : class$de$speexx$ocean$annotator$text$internal$Version1Serializer).desiredAssertionStatus();
        }
    }

    static final class SerializationHelper
    implements Comparable {
        private final AbstractAnnotation a;
        private boolean isOutputed = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        public SerializationHelper(AbstractAnnotation a) {
            if (a == null) {
                throw new IllegalArgumentException(Messages.getString("OutputHelper.1"));
            }
            if (!$assertionsDisabled && a == null) {
                throw new AssertionError();
            }
            this.a = a;
        }

        public int compareTo(Object o) {
            SerializationHelper other = (SerializationHelper)o;
            return INDEX_COMPARATOR.compare(this.a, other.a);
        }

        public AbstractAnnotation getAbstractAnnotation() {
            return this.a;
        }

        public boolean isOutputed() {
            return this.isOutputed;
        }

        public void setOutputed() {
            this.isOutputed = true;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            String clazzName = this.getClass().getName();
            sb.append(clazzName);
            sb.append("[isOutputed:");
            sb.append(this.isOutputed);
            sb.append("[");
            sb.append(this.a);
            sb.append("]]");
            return sb.toString();
        }

        static {
            $assertionsDisabled = !(class$de$speexx$ocean$annotator$text$internal$Version1Serializer == null ? (class$de$speexx$ocean$annotator$text$internal$Version1Serializer = Version1Serializer.class$("de.speexx.ocean.annotator.text.internal.Version1Serializer")) : class$de$speexx$ocean$annotator$text$internal$Version1Serializer).desiredAssertionStatus();
        }
    }
}

