/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.ocean.annotator.text.internal;

public final class XmlCharacterValidator {
    static final char[] BASECHAR_START = new char[]{'A', 'a', '\u00c0', '\u00d8', '\u00f8', '\u0100', '\u0134', '\u0141', '\u014a', '\u0180', '\u01cd', '\u01f4', '\u01fa', '\u0250', '\u02bb', '\u0386', '\u0388', '\u038c', '\u038e', '\u03a3', '\u03d0', '\u03da', '\u03dc', '\u03de', '\u03e0', '\u03e2', '\u0401', '\u040e', '\u0451', '\u045e', '\u0490', '\u04c7', '\u04cb', '\u04d0', '\u04ee', '\u04f8', '\u0531', '\u0559', '\u0561', '\u05d0', '\u05f0', '\u0621', '\u0641', '\u0671', '\u06ba', '\u06c0', '\u06d0', '\u06d5', '\u06e5', '\u0905', '\u093d', '\u0958', '\u0985', '\u098f', '\u0993', '\u09aa', '\u09b2', '\u09b6', '\u09dc', '\u09df', '\u09f0', '\u0a05', '\u0a0f', '\u0a13', '\u0a2a', '\u0a32', '\u0a35', '\u0a38', '\u0a59', '\u0a5e', '\u0a72', '\u0a85', '\u0a8d', '\u0a8f', '\u0a93', '\u0aaa', '\u0ab2', '\u0ab5', '\u0abd', '\u0ae0', '\u0b05', '\u0b0f', '\u0b13', '\u0b2a', '\u0b32', '\u0b36', '\u0b3d', '\u0b5c', '\u0b5f', '\u0b85', '\u0b8e', '\u0b92', '\u0b99', '\u0b9c', '\u0b9e', '\u0ba3', '\u0ba8', '\u0bae', '\u0bb7', '\u0c05', '\u0c0e', '\u0c12', '\u0c2a', '\u0c35', '\u0c60', '\u0c85', '\u0c8e', '\u0c92', '\u0caa', '\u0cb5', '\u0cde', '\u0ce0', '\u0d05', '\u0d0e', '\u0d12', '\u0d2a', '\u0d60', '\u0e01', '\u0e30', '\u0e32', '\u0e40', '\u0e81', '\u0e84', '\u0e87', '\u0e8a', '\u0e8d', '\u0e94', '\u0e99', '\u0ea1', '\u0ea5', '\u0ea7', '\u0eaa', '\u0ead', '\u0eb0', '\u0eb2', '\u0ebd', '\u0ec0', '\u0f40', '\u0f49', '\u10a0', '\u10d0', '\u1100', '\u1102', '\u1105', '\u1109', '\u110b', '\u110e', '\u113c', '\u113e', '\u1140', '\u114c', '\u114e', '\u1150', '\u1154', '\u1159', '\u115f', '\u1163', '\u1165', '\u1167', '\u1169', '\u116d', '\u1172', '\u1175', '\u119e', '\u11a8', '\u11ab', '\u11ae', '\u11b7', '\u11ba', '\u11bc', '\u11eb', '\u11f0', '\u11f9', '\u1e00', '\u1ea0', '\u1f00', '\u1f18', '\u1f20', '\u1f48', '\u1f50', '\u1f59', '\u1f5b', '\u1f5d', '\u1f5f', '\u1f80', '\u1fb6', '\u1fbe', '\u1fc2', '\u1fc6', '\u1fd0', '\u1fd6', '\u1fe0', '\u1ff2', '\u1ff6', '\u2126', '\u212a', '\u212e', '\u2180', '\u3041', '\u30a1', '\u3105', '\uac00'};
    static final char[] BASECHAR_END = new char[]{'Z', 'z', '\u00d6', '\u00f6', '\u00ff', '\u0131', '\u013e', '\u0148', '\u017e', '\u01c3', '\u01f0', '\u01f5', '\u0217', '\u02a8', '\u02c1', '\u0386', '\u038a', '\u038c', '\u03a1', '\u03ce', '\u03d6', '\u03da', '\u03dc', '\u03de', '\u03e0', '\u03f3', '\u040c', '\u044f', '\u045c', '\u0481', '\u04c4', '\u04c8', '\u04cc', '\u04eb', '\u04f5', '\u04f9', '\u0556', '\u0559', '\u0586', '\u05ea', '\u05f2', '\u063a', '\u064a', '\u06b7', '\u06be', '\u06ce', '\u06d3', '\u06d5', '\u06e6', '\u0939', '\u093d', '\u0961', '\u098c', '\u0990', '\u09a8', '\u09b0', '\u09b2', '\u09b9', '\u09dd', '\u09e1', '\u09f1', '\u0a0a', '\u0a10', '\u0a28', '\u0a30', '\u0a33', '\u0a36', '\u0a39', '\u0a5c', '\u0a5e', '\u0a74', '\u0a8b', '\u0a8d', '\u0a91', '\u0aa8', '\u0ab0', '\u0ab3', '\u0ab9', '\u0abd', '\u0ae0', '\u0b0c', '\u0b10', '\u0b28', '\u0b30', '\u0b33', '\u0b39', '\u0b3d', '\u0b5d', '\u0b61', '\u0b8a', '\u0b90', '\u0b95', '\u0b9a', '\u0b9c', '\u0b9f', '\u0ba4', '\u0baa', '\u0bb5', '\u0bb9', '\u0c0c', '\u0c10', '\u0c28', '\u0c33', '\u0c39', '\u0c61', '\u0c8c', '\u0c90', '\u0ca8', '\u0cb3', '\u0cb9', '\u0cde', '\u0ce1', '\u0d0c', '\u0d10', '\u0d28', '\u0d39', '\u0d61', '\u0e2e', '\u0e30', '\u0e33', '\u0e45', '\u0e82', '\u0e84', '\u0e88', '\u0e8a', '\u00e8', '\u0e97', '\u0e9f', '\u0ea3', '\u0ea5', '\u0ea7', '\u0eab', '\u0eae', '\u0eb0', '\u0eb3', '\u0ebd', '\u0ec4', '\u0f47', '\u0f69', '\u10c5', '\u10f6', '\u1100', '\u1103', '\u1107', '\u1109', '\u110c', '\u1112', '\u113c', '\u113e', '\u1140', '\u114c', '\u114e', '\u1150', '\u1155', '\u1159', '\u1161', '\u1163', '\u1165', '\u1167', '\u1169', '\u116e', '\u1173', '\u1175', '\u119e', '\u11a8', '\u11ab', '\u11af', '\u11b8', '\u11ba', '\u11c2', '\u11eb', '\u11f0', '\u11f9', '\u1e9b', '\u1ef9', '\u1f15', '\u1f1d', '\u1f45', '\u1f4d', '\u1f57', '\u1f59', '\u1f5b', '\u1f5d', '\u1f7d', '\u1fb4', '\u1fbc', '\u1fbe', '\u1fc4', '\u1fcc', '\u1fd3', '\u1fdb', '\u1fec', '\u1ff4', '\u1ffc', '\u2126', '\u212b', '\u212e', '\u2182', '\u3094', '\u30fa', '\u312c', '\ud7a3'};
    static final char[] IDEOGRAPHIC_START = new char[]{'\u4e00', '\u3007', '\u3021'};
    static final char[] IDEOGRAPHIC_END = new char[]{'\u9fa5', '\u3007', '\u3029'};
    static final char[] COMBININGCHAR_START = new char[]{'\u0300', '\u0360', '\u0483', '\u0591', '\u05a3', '\u05bb', '\u05bf', '\u05c1', '\u05c4', '\u064b', '\u0670', '\u06d6', '\u06dd', '\u06e0', '\u06e7', '\u06ea', '\u0901', '\u093c', '\u093e', '\u094d', '\u0951', '\u0962', '\u0981', '\u09bc', '\u09be', '\u09bf', '\u09c0', '\u09c7', '\u09cb', '\u09d7', '\u09e2', '\u0a02', '\u0a3c', '\u0a3e', '\u0a3f', '\u0a40', '\u0a47', '\u0a4b', '\u0a70', '\u0a81', '\u0abc', '\u0abe', '\u0ac7', '\u0acb', '\u0b01', '\u0b3c', '\u0b3e', '\u0b47', '\u0b4b', '\u0b56', '\u0b82', '\u0bbe', '\u0bc6', '\u0bca', '\u0bd7', '\u0c01', '\u0c3e', '\u0c46', '\u0c4a', '\u0c55', '\u0c82', '\u0cbe', '\u0cc6', '\u0cca', '\u0cd5', '\u0d02', '\u0d3e', '\u0d46', '\u0d4a', '\u0d57', '\u0e31', '\u0e34', '\u0e47', '\u0eb1', '\u0eb4', '\u0ebb', '\u0ec8', '\u0f18', '\u0f35', '\u0f37', '\u0f39', '\u0f3e', '\u0f3f', '\u0f71', '\u0f86', '\u0f90', '\u0f97', '\u0f99', '\u0fb1', '\u0fb9', '\u20d0', '\u20e1', '\u302a', '\u3099', '\u309a'};
    static final char[] COMBININGCHAR_END = new char[]{'\u0345', '\u0361', '\u0486', '\u05a1', '\u05b9', '\u05bd', '\u05bf', '\u05c2', '\u05c4', '\u0652', '\u0670', '\u06dc', '\u06df', '\u06e4', '\u06e8', '\u06ed', '\u0903', '\u093c', '\u094c', '\u094d', '\u0954', '\u0963', '\u0983', '\u09bc', '\u09be', '\u09bf', '\u09c4', '\u09c8', '\u09cd', '\u09d7', '\u09e3', '\u0a02', '\u0a3c', '\u0a3e', '\u0a3f', '\u0a42', '\u0a48', '\u0a4d', '\u0a71', '\u0a83', '\u0abc', '\u0ac5', '\u0ac9', '\u0acd', '\u0b03', '\u0b3c', '\u0b43', '\u0b48', '\u0b4d', '\u0b57', '\u0b83', '\u0bc2', '\u0bc8', '\u0bcd', '\u0bd7', '\u0c03', '\u0c44', '\u0c48', '\u0c4d', '\u0c56', '\u0c83', '\u0cc4', '\u0cc8', '\u0ccd', '\u0cd6', '\u0d03', '\u0d43', '\u0d48', '\u0d4d', '\u0d57', '\u0e31', '\u0e3a', '\u0e4e', '\u0eb1', '\u0eb9', '\u0ebc', '\u0ecd', '\u0f19', '\u0f35', '\u0f37', '\u0f39', '\u0f3e', '\u0f3f', '\u0f84', '\u0f8b', '\u0f95', '\u0f97', '\u0fad', '\u0fb7', '\u0fb9', '\u20dc', '\u20e1', '\u302f', '\u3099', '\u309a'};
    static final char[] DIGIT_START = new char[]{'0', '\u0660', '\u06f0', '\u0966', '\u09e6', '\u0a66', '\u0ae6', '\u0b66', '\u0be7', '\u0c66', '\u0ce6', '\u0d66', '\u0e50', '\u0ed0', '\u0f20'};
    static final char[] DIGIT_END = new char[]{'9', '\u0669', '\u06f9', '\u096f', '\u09ef', '\u0a6f', '\u0aef', '\u0b6f', '\u0bef', '\u0c6f', '\u0cef', '\u0d6f', '\u0e59', '\u0ed9', '\u0f29'};
    static final char[] EXTENDER_START = new char[]{'\u00b7', '\u02d0', '\u02d1', '\u0387', '\u0640', '\u0e46', '\u0ec6', '\u3005', '\u3031', '\u309d', '\u30fc'};
    static final char[] EXTENDER_END = new char[]{'\u00b7', '\u02d0', '\u02d1', '\u0387', '\u0640', '\u0e46', '\u0ec6', '\u3005', '\u3035', '\u309e', '\u30fe'};
    private static final String XML = "xml";
    private static final int XML_LENGTH = "xml".length();

    public static boolean isBaseChar(char c) {
        for (int i = 0; i < BASECHAR_START.length; ++i) {
            if (c < BASECHAR_START[i] || c > BASECHAR_END[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isCombiningChar(char c) {
        for (int i = 0; i < COMBININGCHAR_START.length; ++i) {
            if (c < COMBININGCHAR_START[i] || c > COMBININGCHAR_END[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isDigit(char c) {
        for (int i = 0; i < DIGIT_START.length; ++i) {
            if (c < DIGIT_START[i] || c > DIGIT_END[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtender(char c) {
        for (int i = 0; i < EXTENDER_START.length; ++i) {
            if (c < EXTENDER_START[i] || c > EXTENDER_END[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isIdeographic(char c) {
        for (int i = 0; i < IDEOGRAPHIC_START.length; ++i) {
            if (c < IDEOGRAPHIC_START[i] || c > IDEOGRAPHIC_END[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isLetter(char c) {
        return XmlCharacterValidator.isBaseChar(c) || XmlCharacterValidator.isIdeographic(c);
    }

    public static boolean isNameChar(char c) {
        return XmlCharacterValidator.isLetter(c) || XmlCharacterValidator.isDigit(c) || c == '.' || c == '-' || c == '_' || c == ':' || XmlCharacterValidator.isCombiningChar(c) || XmlCharacterValidator.isExtender(c);
    }

    public static boolean isNcNameChar(char c) {
        return XmlCharacterValidator.isLetter(c) || XmlCharacterValidator.isDigit(c) || c == '.' || c == '-' || c == '_' || XmlCharacterValidator.isCombiningChar(c) || XmlCharacterValidator.isExtender(c);
    }

    public static boolean isNcName(CharSequence name) {
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (!(i == 0 ? !XmlCharacterValidator.isLetter(c) && c != '_' : !XmlCharacterValidator.isNcNameChar(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isName(CharSequence name) {
        if (XmlCharacterValidator.startsWithXml(name)) {
            return false;
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (!(i == 0 ? !XmlCharacterValidator.isLetter(c) && c != '_' && c != ':' : !XmlCharacterValidator.isNameChar(c))) continue;
            return false;
        }
        return true;
    }

    static boolean startsWithXml(CharSequence s) {
        if (s.length() >= XML_LENGTH) {
            char[] array = new char[XML_LENGTH];
            for (int i = 0; i < XML_LENGTH; ++i) {
                array[i] = s.charAt(i);
            }
            String toTest = new String(array).toLowerCase();
            if (XML.equals(toTest)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isNmToken(CharSequence name) {
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (XmlCharacterValidator.isNameChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isS(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static boolean isSpace(char c) {
        return XmlCharacterValidator.isS(c);
    }

    public static boolean isChar(char c) {
        if (XmlCharacterValidator.isS(c)) {
            return true;
        }
        if (c >= '!' && c <= '\ud7ff') {
            return true;
        }
        return c >= '\ue000' && c <= '\ufffd';
    }

    private XmlCharacterValidator() {
    }
}

