/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.jndikit.rmi.server;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.rmi.MarshalledObject;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import org.codehaus.spice.jndikit.DefaultNameParser;
import org.codehaus.spice.jndikit.DefaultNamespace;
import org.codehaus.spice.jndikit.memory.MemoryContext;
import org.codehaus.spice.jndikit.rmi.server.RMINamingProviderImpl;

public class Main
implements Runnable {
    private final boolean m_debug;
    private final int m_port;
    private boolean m_isRunning;
    private boolean m_isInitialized;
    private RMINamingProviderImpl m_server;
    private ServerSocket m_serverSocket;
    private MarshalledObject m_serverStub;

    public Main(boolean debug, int port) {
        this.m_debug = debug;
        this.m_port = port;
    }

    public void init() throws Exception {
        if (this.m_isInitialized) {
            return;
        }
        try {
            this.m_serverSocket = new ServerSocket(this.m_port);
            this.m_serverSocket.setSoTimeout(100);
            this.debug("Started server on port " + this.m_serverSocket.getLocalPort());
            this.m_isInitialized = true;
        }
        catch (IOException ioe) {
            this.debug("Failed starting server");
            throw ioe;
        }
    }

    public void start() throws Exception {
        this.init();
        this.export();
    }

    public void export() throws Exception {
        DefaultNameParser parser = new DefaultNameParser();
        DefaultNamespace namespace = new DefaultNamespace(parser);
        MemoryContext context = new MemoryContext(namespace, null, null);
        this.m_server = new RMINamingProviderImpl(context);
        try {
            this.debug("Exporting RMI object.");
            RemoteStub remote = UnicastRemoteObject.exportObject(this.m_server);
            this.m_serverStub = new MarshalledObject<RemoteStub>(remote);
        }
        catch (IOException ioe) {
            this.debug("Failed exporting object");
            ioe.printStackTrace();
            throw ioe;
        }
    }

    public void run() {
        this.accept();
    }

    public void dispose() throws Exception {
        this.debug("Shutting down server");
        this.m_isRunning = false;
        ServerSocket serverSocket = this.m_serverSocket;
        this.m_serverSocket = null;
        serverSocket.close();
        this.debug("Server shutdown");
    }

    public void stop() throws Exception {
        this.debug("Stopping");
        this.m_isRunning = false;
        this.debug("Unexporting object");
        UnicastRemoteObject.unexportObject(this.m_server, true);
        this.m_serverStub = null;
        this.debug("Server stopped");
    }

    public boolean isRunning() {
        return this.m_isRunning;
    }

    public void accept() {
        this.m_isRunning = true;
        while (this.m_isRunning) {
            try {
                Socket socket = this.m_serverSocket.accept();
                this.debug("Accepted Connection");
                ObjectOutputStream output = new ObjectOutputStream(socket.getOutputStream());
                output.writeObject(this.m_serverStub);
                socket.close();
            }
            catch (SocketTimeoutException ste) {
            }
            catch (IOException ioe) {
                if (!this.m_isRunning) break;
                ioe.printStackTrace();
            }
        }
    }

    private void debug(String message) {
        if (this.m_debug) {
            System.out.println("RNC: " + message);
        }
    }
}

