/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.threadpool.impl;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.codehaus.spice.threadpool.impl.AvalonLoggerThreadPoolMonitor;
import org.codehaus.spice.threadpool.impl.CommonsThreadPool;

public class AvalonCommonsThreadPool
extends CommonsThreadPool
implements LogEnabled,
Configurable,
Initializable,
Disposable {
    private Logger m_logger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        String name = configuration.getChild("name").getValue();
        this.setName(name);
        int priority = configuration.getChild("priority").getValueAsInteger(5);
        this.setPriority(priority);
        boolean isDaemon = configuration.getChild("is-daemon").getValueAsBoolean(false);
        this.setDaemon(isDaemon);
        GenericObjectPool.Config config = this.getCommonsConfig();
        boolean limit = configuration.getChild("resource-limiting").getValueAsBoolean(false);
        config.whenExhaustedAction = limit ? (byte)1 : (byte)2;
        config.maxActive = configuration.getChild("max-threads").getValueAsInteger(10);
        config.maxIdle = configuration.getChild("max-idle").getValueAsInteger(config.maxActive / 2);
    }

    public void initialize() throws Exception {
        AvalonLoggerThreadPoolMonitor monitor = new AvalonLoggerThreadPoolMonitor();
        ContainerUtil.enableLogging((Object)monitor, (Logger)this.m_logger);
        this.setMonitor(monitor);
        this.setup();
    }

    public void dispose() {
        this.shutdown();
    }
}

