/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.threadpool.impl;

import org.codehaus.spice.threadpool.ThreadPoolMonitor;
import org.jcontainer.dna.AbstractLogEnabled;

class DNAThreadPoolMonitor
extends AbstractLogEnabled
implements ThreadPoolMonitor {
    DNAThreadPoolMonitor() {
    }

    public void newThreadPool(String name, int priority, boolean daemon, int maxActive, int maxIdle) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Creating a new ThreadPool " + name + "(priority=" + priority + ",isDaemon=" + daemon + ") with " + "max-threads=" + maxActive + " and " + "max-idle=" + maxIdle);
        }
    }

    public void threadRetrieved(Thread thread) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Thread retrieved - " + thread.getName());
        }
    }

    public void threadReturned(Thread thread) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Thread returned - " + thread.getName());
        }
    }

    public void threadCreated(Thread thread) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Thread Created - " + thread.getName());
        }
    }

    public void threadDisposing(Thread thread) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Thread Disposing - " + thread.getName());
        }
    }

    public void unexpectedError(String message, Throwable t) {
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Unexpected Error (" + message + ")", t);
        }
    }
}

