/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.threadpool.impl;

import org.apache.commons.pool.impl.GenericObjectPool;
import org.codehaus.spice.threadpool.ThreadPoolMonitor;
import org.codehaus.spice.threadpool.impl.CommonsThreadPool;
import org.codehaus.spice.threadpool.impl.NullThreadPoolMonitor;

public class PicoCommonsThreadPool
extends CommonsThreadPool {
    protected PicoCommonsThreadPool(ThreadPoolMonitor monitor, String name, int priority, boolean isDaemon, boolean limited, int maxActiveThreads, int maxIdleThreads) {
        this.setMonitor(monitor);
        this.setName(name);
        this.setPriority(priority);
        this.setDaemon(isDaemon);
        GenericObjectPool.Config config = this.getCommonsConfig();
        config.whenExhaustedAction = limited ? (byte)1 : (byte)2;
        config.maxActive = maxActiveThreads;
        config.maxIdle = maxIdleThreads;
        this.setup();
    }

    protected void finalize() {
        this.shutdown();
    }

    public static class WithMonitorAndConfig
    extends PicoCommonsThreadPool {
        public WithMonitorAndConfig(ThreadPoolMonitor monitor, String name, int priority, boolean isDaemon, boolean limited, int maxActiveThreads, int maxIdleThreads) {
            super(monitor, name, priority, isDaemon, limited, maxActiveThreads, maxIdleThreads);
        }
    }

    public static class WithMonitor
    extends PicoCommonsThreadPool {
        public WithMonitor(ThreadPoolMonitor monitor) {
            super(monitor, "Default ThreadPool", 5, false, false, 10, 5);
        }
    }

    public static class Default
    extends PicoCommonsThreadPool {
        public Default() {
            super(new NullThreadPoolMonitor(), "Default ThreadPool", 5, false, false, 10, 5);
        }
    }
}

