/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.threadpool.impl;

import org.codehaus.spice.threadpool.Executable;
import org.codehaus.spice.threadpool.ThreadControl;
import org.codehaus.spice.threadpool.impl.AbstractThreadPool;
import org.codehaus.spice.threadpool.impl.DefaultThreadControl;

public class WorkerThread
extends Thread {
    private Executable m_work;
    private DefaultThreadControl m_threadControl;
    private boolean m_alive;
    private final String m_name;
    private final AbstractThreadPool m_pool;

    protected WorkerThread(AbstractThreadPool pool, ThreadGroup group, String name) {
        super(group, "");
        if (null == name) {
            throw new NullPointerException("name");
        }
        if (null == pool) {
            throw new NullPointerException("pool");
        }
        this.setName(name);
        this.m_name = name;
        this.m_work = null;
        this.m_alive = true;
        this.m_pool = pool;
        this.setDaemon(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.debug("starting.");
        while (this.m_alive) {
            Object var4_5;
            this.waitUntilCondition(true);
            this.debug("running.");
            Throwable throwable = null;
            try {
                try {
                    this.preExecute();
                    this.m_work.execute();
                }
                catch (ThreadDeath threadDeath) {
                    this.debug("thread has died.");
                    throwable = threadDeath;
                    throw threadDeath;
                }
                catch (Throwable t) {
                    this.debug("error caught: " + t);
                    throwable = t;
                    var4_5 = null;
                    this.debug("done.");
                    this.m_work = null;
                    this.m_threadControl.finish(throwable);
                    this.m_threadControl = null;
                    this.postExecute();
                }
                var4_5 = null;
                this.debug("done.");
                this.m_work = null;
                this.m_threadControl.finish(throwable);
                this.m_threadControl = null;
                this.postExecute();
            }
            catch (Throwable throwable2) {
                var4_5 = null;
                this.debug("done.");
                this.m_work = null;
                this.m_threadControl.finish(throwable);
                this.m_threadControl = null;
                this.postExecute();
                throw throwable2;
            }
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                this.notifyAll();
            }
            this.recycleThread();
        }
    }

    protected void recycleThread() {
        if (this.m_alive) {
            this.m_pool.threadCompleted(this);
        }
    }

    protected void postExecute() {
    }

    protected void preExecute() {
        Thread.currentThread().setName(this.m_name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose(int maxWait) {
        this.debug("destroying.");
        this.m_alive = false;
        this.interrupt();
        WorkerThread workerThread = this;
        synchronized (workerThread) {
            long start = System.currentTimeMillis();
            while (null != this.m_work) {
                long now = System.currentTimeMillis();
                long diff = now - start;
                if (diff >= (long)maxWait) {
                    return;
                }
                try {
                    long timeout = (long)maxWait - diff;
                    this.debug("waiting timeout=" + timeout + ".");
                    this.wait(timeout);
                    this.debug("notified.");
                }
                catch (InterruptedException ie) {}
            }
        }
    }

    protected synchronized ThreadControl execute(Executable work) {
        this.m_work = work;
        this.m_threadControl = new DefaultThreadControl(this);
        this.debug("notifying this worker.");
        this.notify();
        return this.m_threadControl;
    }

    private synchronized void waitUntilCondition(boolean hasWork) {
        while (hasWork == (null == this.m_work)) {
            try {
                this.debug("waiting.");
                this.wait();
                this.debug("notified.");
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void debug(String message) {
    }
}

