/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.threadpool.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.spice.threadpool.Executable;
import org.codehaus.spice.threadpool.ThreadControl;
import org.codehaus.spice.threadpool.ThreadPool;
import org.codehaus.spice.threadpool.impl.ExecutableRunnable;
import org.codehaus.spice.threadpool.impl.WorkerThread;

public abstract class AbstractThreadPool
implements ThreadPool {
    private Set m_inUse = Collections.synchronizedSet(new HashSet());
    private ThreadGroup m_threadGroup;
    private String m_name;
    private int m_level;
    private boolean m_isDaemon;
    private int m_priority;
    private int m_disposeTime = 100;

    protected void destroyWorker(WorkerThread worker) {
        worker.dispose(this.getDisposeTime());
    }

    protected WorkerThread createWorker() {
        String name = this.getName() + " Worker #" + this.m_level++;
        WorkerThread worker = this.newWorkerThread(name);
        worker.setDaemon(this.m_isDaemon);
        worker.setPriority(this.m_priority);
        worker.start();
        return worker;
    }

    protected WorkerThread newWorkerThread(String name) {
        return new WorkerThread(this, this.getThreadGroup(), name);
    }

    public ThreadControl execute(Runnable work) {
        return this.execute(new ExecutableRunnable(work));
    }

    public ThreadControl execute(Executable work) {
        WorkerThread worker = this.getWorker();
        worker.setPriority(this.m_priority);
        this.m_inUse.add(worker);
        return worker.execute(work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownInUseThreads() {
        Set set = this.m_inUse;
        synchronized (set) {
            Iterator iterator = this.m_inUse.iterator();
            while (iterator.hasNext()) {
                WorkerThread worker = (WorkerThread)iterator.next();
                this.destroyWorker(worker);
            }
            this.m_inUse.clear();
        }
    }

    protected String getName() {
        return this.m_name;
    }

    protected void setName(String name) {
        this.m_name = name;
    }

    protected void setDaemon(boolean daemon) {
        this.m_isDaemon = daemon;
    }

    protected boolean isDaemon() {
        return this.m_isDaemon;
    }

    protected void setPriority(int priority) {
        this.m_priority = priority;
    }

    protected int getPriority() {
        return this.m_priority;
    }

    protected ThreadGroup getThreadGroup() {
        return this.m_threadGroup;
    }

    protected void setThreadGroup(ThreadGroup threadGroup) {
        this.m_threadGroup = threadGroup;
    }

    protected int getDisposeTime() {
        return this.m_disposeTime;
    }

    protected void setDisposeTime(int disposeTime) {
        this.m_disposeTime = disposeTime;
    }

    protected void threadCompleted(WorkerThread worker) {
        this.m_inUse.remove(worker);
        this.releaseWorker(worker);
    }

    protected abstract WorkerThread getWorker();

    protected abstract void releaseWorker(WorkerThread var1);
}

