/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.threadpool.impl;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.codehaus.spice.threadpool.ThreadPool;
import org.codehaus.spice.threadpool.ThreadPoolMonitor;
import org.codehaus.spice.threadpool.impl.AbstractThreadPool;
import org.codehaus.spice.threadpool.impl.WorkerThread;

public class CommonsThreadPool
extends AbstractThreadPool
implements ThreadPool,
PoolableObjectFactory {
    private final GenericObjectPool.Config m_config = new GenericObjectPool.Config();
    private GenericObjectPool m_pool;
    private boolean m_disposed;
    private ThreadPoolMonitor m_monitor;

    public void setup() {
        this.setThreadGroup(Thread.currentThread().getThreadGroup());
        this.m_monitor.newThreadPool(this.getName(), this.getPriority(), this.isDaemon(), this.m_config.maxActive, this.m_config.maxIdle);
        this.m_pool = new GenericObjectPool((PoolableObjectFactory)this, this.m_config);
        this.setDisposeTime(100);
    }

    public void shutdown() {
        this.shutdownInUseThreads();
        this.m_disposed = true;
        try {
            this.m_pool.close();
        }
        catch (Exception e) {
            String message = "Error closing pool: " + e;
            this.m_monitor.unexpectedError(message, e);
        }
    }

    protected WorkerThread getWorker() {
        try {
            WorkerThread worker = (WorkerThread)this.m_pool.borrowObject();
            this.m_monitor.threadRetrieved(worker);
            return worker;
        }
        catch (Exception e) {
            this.m_monitor.unexpectedError("Retrieving thread from pool", e);
            return this.createWorker();
        }
    }

    protected void releaseWorker(WorkerThread worker) {
        if (this.m_disposed) {
            String message = "Ignoring attempt to return worker to disposed pool: " + worker.getName() + ". Attempting dispose of worker.";
            this.m_monitor.unexpectedError(message, null);
            this.destroyWorker(worker);
            return;
        }
        this.m_monitor.threadReturned(worker);
        try {
            this.m_pool.returnObject((Object)worker);
        }
        catch (Exception e) {
            String message = "Returning '" + worker.getName() + "' To Pool";
            this.m_monitor.unexpectedError(message, e);
        }
    }

    protected WorkerThread createWorker() {
        WorkerThread worker = super.createWorker();
        this.m_monitor.threadCreated(worker);
        return worker;
    }

    protected void destroyWorker(WorkerThread worker) {
        this.m_monitor.threadDisposing(worker);
        super.destroyWorker(worker);
    }

    public Object makeObject() {
        return this.createWorker();
    }

    public void destroyObject(Object worker) {
        this.destroyWorker((WorkerThread)worker);
    }

    public boolean validateObject(Object worker) {
        return true;
    }

    public void activateObject(Object worker) {
    }

    public void passivateObject(Object worker) {
    }

    protected final GenericObjectPool.Config getCommonsConfig() {
        return this.m_config;
    }

    protected final void setMonitor(ThreadPoolMonitor monitor) {
        this.m_monitor = monitor;
    }
}

