/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.threadpool.impl;

import org.apache.commons.pool.impl.GenericObjectPool;
import org.codehaus.dna.Active;
import org.codehaus.dna.Configurable;
import org.codehaus.dna.Configuration;
import org.codehaus.dna.ConfigurationException;
import org.codehaus.dna.LogEnabled;
import org.codehaus.dna.Logger;
import org.codehaus.dna.impl.ContainerUtil;
import org.codehaus.spice.threadpool.impl.CommonsThreadPool;
import org.codehaus.spice.threadpool.impl.DNAThreadPoolMonitor;

public class DNACommonsThreadPool
extends CommonsThreadPool
implements LogEnabled,
Configurable,
Active {
    private Logger m_logger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        String name = configuration.getChild("name").getValue();
        this.setName(name);
        int priority = configuration.getChild("priority").getValueAsInteger(5);
        this.setPriority(priority);
        boolean isDaemon = configuration.getChild("is-daemon").getValueAsBoolean(false);
        this.setDaemon(isDaemon);
        GenericObjectPool.Config config = this.getCommonsConfig();
        boolean limit = configuration.getChild("resource-limiting").getValueAsBoolean(false);
        config.whenExhaustedAction = limit ? (byte)1 : (byte)2;
        config.maxActive = configuration.getChild("max-threads").getValueAsInteger(10);
        config.maxIdle = configuration.getChild("max-idle").getValueAsInteger(config.maxActive / 2);
    }

    public void initialize() throws Exception {
        DNAThreadPoolMonitor monitor = new DNAThreadPoolMonitor();
        ContainerUtil.enableLogging((Object)monitor, (Logger)this.m_logger);
        this.setMonitor(monitor);
        this.setup();
    }

    public void dispose() {
        this.shutdown();
    }
}

