/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockRequestDispatcher;

public class MockServletContext
implements ServletContext {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String resourceBasePath;
    private final ResourceLoader resourceLoader;
    private final Properties initParameters = new Properties();
    private final Hashtable attributes = new Hashtable();

    public MockServletContext() {
        this.resourceBasePath = null;
        this.resourceLoader = null;
    }

    public MockServletContext(String resourceBasePath) {
        this.resourceBasePath = resourceBasePath;
        this.resourceLoader = new DefaultResourceLoader();
    }

    public MockServletContext(String warRoot, ResourceLoader resourceLoader) {
        this.resourceBasePath = warRoot;
        this.resourceLoader = resourceLoader;
    }

    protected String getResourceLocation(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.resourceBasePath + path;
    }

    public ServletContext getContext(String name) {
        throw new UnsupportedOperationException("getContext");
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 3;
    }

    public String getMimeType(String filePath) {
        throw new UnsupportedOperationException("getMimeType");
    }

    public Set getResourcePaths(String path) {
        throw new UnsupportedOperationException("getResourcePaths");
    }

    public URL getResource(String path) throws MalformedURLException {
        if (this.resourceBasePath == null) {
            throw new UnsupportedOperationException("No WAR root: getResource fails");
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return new URL(this.resourceBasePath + path);
    }

    public InputStream getResourceAsStream(String path) {
        if (this.resourceBasePath == null) {
            throw new UnsupportedOperationException("No WAR root: getResourceAsStream fails");
        }
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            return resource.getInputStream();
        }
        catch (IOException ex) {
            this.logger.error((Object)("Couldn't open resource " + resource), (Throwable)ex);
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String path) {
        throw new UnsupportedOperationException("getNamedDispatcher");
    }

    public Servlet getServlet(String name) {
        throw new UnsupportedOperationException("getServlet");
    }

    public Enumeration getServlets() {
        throw new UnsupportedOperationException("getServlets");
    }

    public Enumeration getServletNames() {
        throw new UnsupportedOperationException("getServletNames");
    }

    public void log(String message) {
        this.logger.info((Object)message);
    }

    public void log(Exception e, String message) {
        this.logger.info((Object)message, (Throwable)e);
    }

    public void log(String message, Throwable t) {
        this.logger.info((Object)message, t);
    }

    public String getRealPath(String path) {
        if (this.resourceBasePath == null) {
            throw new UnsupportedOperationException("No WAR root: getRealPath fails");
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.resourceBasePath + path;
    }

    public String getServerInfo() {
        return "MockServletContext";
    }

    public String getInitParameter(String name) {
        return this.initParameters.getProperty(name);
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public Enumeration getInitParameterNames() {
        return this.initParameters.keys();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getServletContextName() {
        return "MockServletContext";
    }
}

