/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.Serializable;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.util.StringUtils;

public class DefaultMessageSourceResolvable
implements MessageSourceResolvable,
Serializable {
    private String[] codes;
    private Object[] arguments;
    private String defaultMessage;

    public DefaultMessageSourceResolvable(String[] codes, Object[] arguments) {
        this(codes, arguments, null);
    }

    public DefaultMessageSourceResolvable(String[] codes, Object[] arguments, String defaultMessage) {
        this.codes = codes;
        this.arguments = arguments;
        this.defaultMessage = defaultMessage;
    }

    public DefaultMessageSourceResolvable(MessageSourceResolvable resolvable) {
        this(resolvable.getCodes(), resolvable.getArguments(), resolvable.getDefaultMessage());
    }

    public String[] getCodes() {
        return this.codes;
    }

    public String getCode() {
        return this.codes != null && this.codes.length > 0 ? this.codes[this.codes.length - 1] : null;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    protected String resolvableToString() {
        StringBuffer buf = new StringBuffer();
        buf.append("codes=[").append(StringUtils.arrayToDelimitedString(this.getCodes(), ",")).append("]; arguments=[");
        if (this.arguments == null) {
            buf.append("null");
        } else {
            for (int i = 0; i < this.getArguments().length; ++i) {
                buf.append('(').append(this.getArguments()[i].getClass().getName()).append(")[");
                buf.append(this.getArguments()[i]).append(']');
                if (i >= this.getArguments().length - 1) continue;
                buf.append(", ");
            }
        }
        buf.append("]; defaultMessage=[").append(this.getDefaultMessage()).append(']');
        return buf.toString();
    }

    public String toString() {
        return this.resolvableToString();
    }
}

