/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlProvider;

public class PreparedStatementCreatorFactory {
    private String sql;
    private final List declaredParameters;
    private int resultSetType = 1003;
    private boolean updatableResults = false;

    public PreparedStatementCreatorFactory(String sql) {
        this.sql = sql;
        this.declaredParameters = new LinkedList();
    }

    public PreparedStatementCreatorFactory(String sql, int[] types) {
        this(sql, SqlParameter.sqlTypesToAnonymousParameterList(types));
    }

    public PreparedStatementCreatorFactory(String sql, List declaredParameters) {
        this.sql = sql;
        this.declaredParameters = declaredParameters;
    }

    public void addParameter(SqlParameter param) {
        this.declaredParameters.add(param);
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public void setUpdatableResults(boolean updatableResults) {
        this.updatableResults = updatableResults;
    }

    public PreparedStatementCreator newPreparedStatementCreator(Object[] params) {
        return new PreparedStatementCreatorImpl(params != null ? Arrays.asList(params) : Collections.EMPTY_LIST);
    }

    public PreparedStatementCreator newPreparedStatementCreator(List params) {
        return new PreparedStatementCreatorImpl(params != null ? params : Collections.EMPTY_LIST);
    }

    private class PreparedStatementCreatorImpl
    implements PreparedStatementCreator,
    SqlProvider {
        private List parameters;

        private PreparedStatementCreatorImpl(List params) {
            this.parameters = params;
            if (this.parameters.size() != PreparedStatementCreatorFactory.this.declaredParameters.size()) {
                throw new InvalidDataAccessApiUsageException("SQL='" + PreparedStatementCreatorFactory.this.sql + "': given " + this.parameters.size() + " parameter but expected " + PreparedStatementCreatorFactory.this.declaredParameters.size());
            }
        }

        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            PreparedStatement ps = null;
            ps = PreparedStatementCreatorFactory.this.resultSetType == 1003 && !PreparedStatementCreatorFactory.this.updatableResults ? con.prepareStatement(PreparedStatementCreatorFactory.this.sql) : con.prepareStatement(PreparedStatementCreatorFactory.this.sql, PreparedStatementCreatorFactory.this.resultSetType, PreparedStatementCreatorFactory.this.updatableResults ? 1008 : 1007);
            block3: for (int i = 0; i < this.parameters.size(); ++i) {
                SqlParameter declaredParameter = (SqlParameter)PreparedStatementCreatorFactory.this.declaredParameters.get(i);
                if (this.parameters.get(i) == null) {
                    ps.setNull(i + 1, declaredParameter.getSqlType());
                    continue;
                }
                switch (declaredParameter.getSqlType()) {
                    case 12: {
                        ps.setString(i + 1, (String)this.parameters.get(i));
                        continue block3;
                    }
                    default: {
                        ps.setObject(i + 1, this.parameters.get(i), declaredParameter.getSqlType());
                    }
                }
            }
            return ps;
        }

        public String getSql() {
            return PreparedStatementCreatorFactory.this.sql;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("PreparedStatementCreatorFactory.PreparedStatementCreatorImpl: sql=[");
            buf.append(PreparedStatementCreatorFactory.this.sql);
            buf.append("]: params=[");
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(this.parameters.get(i));
            }
            return buf.toString() + "]";
        }
    }
}

