/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeEditor;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class NameMatchTransactionAttributeSource
implements TransactionAttributeSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map nameMap = new HashMap();

    public void setNameMap(Map nameMap) {
        this.nameMap = nameMap;
    }

    public void setProperties(Properties transactionAttributes) {
        TransactionAttributeEditor tae = new TransactionAttributeEditor();
        Iterator<Object> it = transactionAttributes.keySet().iterator();
        while (it.hasNext()) {
            String methodName = (String)it.next();
            String value = transactionAttributes.getProperty(methodName);
            tae.setAsText(value);
            TransactionAttribute attr = (TransactionAttribute)tae.getValue();
            this.addTransactionalMethod(methodName, attr);
        }
    }

    public void addTransactionalMethod(String methodName, TransactionAttribute attr) {
        this.logger.debug((Object)("Adding transactional method [" + methodName + "] with attribute [" + attr + "]"));
        this.nameMap.put(methodName, attr);
    }

    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        String methodName = method.getName();
        TransactionAttribute attr = (TransactionAttribute)this.nameMap.get(methodName);
        if (attr != null) {
            return attr;
        }
        String bestNameMatch = null;
        Iterator it = this.nameMap.keySet().iterator();
        while (it.hasNext()) {
            String mappedName = (String)it.next();
            if (!this.isMatch(methodName, mappedName) || bestNameMatch != null && bestNameMatch.length() > mappedName.length()) continue;
            attr = (TransactionAttribute)this.nameMap.get(mappedName);
            bestNameMatch = mappedName;
        }
        return attr;
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return mappedName.endsWith("*") && methodName.startsWith(mappedName.substring(0, mappedName.length() - 1)) || mappedName.startsWith("*") && methodName.endsWith(mappedName.substring(1, mappedName.length()));
    }
}

