/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.util.Properties;
import org.aopalliance.aop.Advice;
import org.aopalliance.aop.AspectException;
import org.springframework.aop.Pointcut;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSourceAdvisor;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class TransactionProxyFactoryBean
extends ProxyConfig
implements FactoryBean,
InitializingBean {
    private PlatformTransactionManager transactionManager;
    private Object target;
    private Class[] proxyInterfaces;
    private TransactionAttributeSource transactionAttributeSource;
    private Pointcut pointcut;
    private Object[] preInterceptors;
    private Object[] postInterceptors;
    private Object proxy;

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setProxyInterfaces(String[] interfaceNames) throws AspectException, ClassNotFoundException {
        this.proxyInterfaces = AopUtils.toInterfaceArray(interfaceNames);
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        this.transactionAttributeSource = transactionAttributeSource;
    }

    public void setTransactionAttributes(Properties transactionAttributes) {
        NameMatchTransactionAttributeSource tas = new NameMatchTransactionAttributeSource();
        tas.setProperties(transactionAttributes);
        this.transactionAttributeSource = tas;
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    public void setPreInterceptors(Object[] preInterceptors) {
        this.preInterceptors = preInterceptors;
    }

    public void setPostInterceptors(Object[] preInterceptors) {
        this.postInterceptors = preInterceptors;
    }

    public void afterPropertiesSet() throws AopConfigException {
        if (this.target == null) {
            throw new AopConfigException("Target must be set");
        }
        if (this.transactionAttributeSource == null) {
            throw new AopConfigException("Either 'transactionAttributeSource' or 'transactionAttributes' is required: If there are no transactional methods, don't use a transactional proxy.");
        }
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor();
        transactionInterceptor.setTransactionManager(this.transactionManager);
        transactionInterceptor.setTransactionAttributeSource(this.transactionAttributeSource);
        transactionInterceptor.afterPropertiesSet();
        ProxyFactory proxyFactory = new ProxyFactory();
        if (this.preInterceptors != null) {
            for (int i = 0; i < this.preInterceptors.length; ++i) {
                proxyFactory.addAdvisor(GlobalAdvisorAdapterRegistry.getInstance().wrap(this.preInterceptors[i]));
            }
        }
        if (this.pointcut != null) {
            DefaultPointcutAdvisor advice = new DefaultPointcutAdvisor(this.pointcut, (Advice)transactionInterceptor);
            proxyFactory.addAdvisor(advice);
        } else {
            proxyFactory.addAdvisor(new TransactionAttributeSourceAdvisor(transactionInterceptor));
        }
        if (this.postInterceptors != null) {
            for (int i = 0; i < this.postInterceptors.length; ++i) {
                proxyFactory.addAdvisor(GlobalAdvisorAdapterRegistry.getInstance().wrap(this.postInterceptors[i]));
            }
        }
        proxyFactory.copyFrom(this);
        proxyFactory.setTargetSource(this.createTargetSource(this.target));
        if (this.proxyInterfaces != null) {
            proxyFactory.setInterfaces(this.proxyInterfaces);
        } else if (!this.getProxyTargetClass()) {
            proxyFactory.setInterfaces(AopUtils.getAllInterfaces(this.target));
        }
        this.proxy = proxyFactory.getProxy();
    }

    protected TargetSource createTargetSource(Object target) {
        if (target instanceof TargetSource) {
            return (TargetSource)target;
        }
        return new SingletonTargetSource(target);
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class getObjectType() {
        if (this.proxy != null) {
            return this.proxy.getClass();
        }
        if (this.target != null) {
            return this.target.getClass();
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }
}

