/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.util.StringUtils;

public abstract class HttpServletBean
extends HttpServlet {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Set requiredProperties = new HashSet();

    protected final void addRequiredProperty(String property) {
        this.requiredProperties.add(property);
    }

    public final void init() throws ServletException {
        this.logger.info((Object)("Initializing servlet '" + this.getServletName() + "'"));
        try {
            ServletConfigPropertyValues pvs = new ServletConfigPropertyValues(this.getServletConfig(), this.requiredProperties);
            BeanWrapperImpl bw = new BeanWrapperImpl((Object)this);
            bw.setPropertyValues(pvs);
        }
        catch (BeansException ex) {
            this.logger.error((Object)("Failed to set bean properties on servlet '" + this.getServletName() + "'"), (Throwable)ex);
            throw ex;
        }
        this.initServletBean();
        this.logger.info((Object)("Servlet '" + this.getServletName() + "' configured successfully"));
    }

    protected void initServletBean() throws ServletException {
    }

    private static class ServletConfigPropertyValues
    extends MutablePropertyValues {
        private ServletConfigPropertyValues(ServletConfig config, Set requiredProperties) throws ServletException {
            HashSet missingProps = requiredProperties != null && !requiredProperties.isEmpty() ? new HashSet(requiredProperties) : null;
            Enumeration enumeration = config.getInitParameterNames();
            while (enumeration.hasMoreElements()) {
                String property = (String)enumeration.nextElement();
                String value = config.getInitParameter(property);
                this.addPropertyValue(new PropertyValue(property, value));
                if (missingProps == null) continue;
                missingProps.remove(property);
            }
            if (missingProps != null && missingProps.size() > 0) {
                throw new ServletException("Initialization from ServletConfig for servlet '" + config.getServletName() + "' failed; the following required properties were missing: " + StringUtils.collectionToDelimitedString(missingProps, ", "));
            }
        }
    }
}

