/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxrpc;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.remoting.jaxrpc.JaxRpcServicePostProcessor;

public class LocalJaxRpcServiceFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class serviceFactoryClass;
    private URL wsdlDocumentUrl;
    private String namespaceUri;
    private String serviceName;
    private JaxRpcServicePostProcessor[] servicePostProcessors;
    static /* synthetic */ Class class$javax$xml$rpc$ServiceFactory;

    public void setServiceFactoryClass(Class serviceFactoryClass) {
        if (serviceFactoryClass != null && !(class$javax$xml$rpc$ServiceFactory == null ? (class$javax$xml$rpc$ServiceFactory = LocalJaxRpcServiceFactory.class$("javax.xml.rpc.ServiceFactory")) : class$javax$xml$rpc$ServiceFactory).isAssignableFrom(serviceFactoryClass)) {
            throw new IllegalArgumentException("serviceFactoryClass must implement [javax.xml.rpc.ServiceFactory]");
        }
        this.serviceFactoryClass = serviceFactoryClass;
    }

    public Class getServiceFactoryClass() {
        return this.serviceFactoryClass;
    }

    public void setWsdlDocumentUrl(URL wsdlDocumentUrl) {
        this.wsdlDocumentUrl = wsdlDocumentUrl;
    }

    public URL getWsdlDocumentUrl() {
        return this.wsdlDocumentUrl;
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServicePostProcessors(JaxRpcServicePostProcessor[] servicePostProcessors) {
        this.servicePostProcessors = servicePostProcessors;
    }

    public JaxRpcServicePostProcessor[] getServicePostProcessors() {
        return this.servicePostProcessors;
    }

    public QName getQName(String name) {
        return this.namespaceUri != null ? new QName(this.namespaceUri, name) : new QName(name);
    }

    public ServiceFactory createServiceFactory() throws ServiceException {
        if (this.serviceFactoryClass != null) {
            return (ServiceFactory)BeanUtils.instantiateClass((Class)this.serviceFactoryClass);
        }
        return ServiceFactory.newInstance();
    }

    public Service createJaxRpcService() throws ServiceException {
        if (this.serviceName == null) {
            throw new IllegalArgumentException("serviceName is required");
        }
        ServiceFactory serviceFactory = this.createServiceFactory();
        QName serviceQName = this.getQName(this.serviceName);
        Service service = this.wsdlDocumentUrl != null ? serviceFactory.createService(this.wsdlDocumentUrl, serviceQName) : serviceFactory.createService(serviceQName);
        this.postProcessJaxRpcService(service);
        return service;
    }

    protected void postProcessJaxRpcService(Service service) {
        if (this.servicePostProcessors != null) {
            for (int i = 0; i < this.servicePostProcessors.length; ++i) {
                this.servicePostProcessors[i].postProcessJaxRpcService(service);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

