/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.httpinvoker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.springframework.remoting.httpinvoker.AbstractHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.support.RemoteInvocationResult;

public class SimpleHttpInvokerRequestExecutor
extends AbstractHttpInvokerRequestExecutor {
    protected RemoteInvocationResult doExecuteRequest(HttpInvokerClientConfiguration config, ByteArrayOutputStream baos) throws IOException, ClassNotFoundException {
        URLConnection con = new URL(config.getServiceUrl()).openConnection();
        if (!(con instanceof HttpURLConnection)) {
            throw new IOException("Service URL [" + config.getServiceUrl() + "] is not an HTTP URL");
        }
        HttpURLConnection httpCon = (HttpURLConnection)con;
        this.prepareConnection(httpCon, baos.size());
        baos.writeTo(httpCon.getOutputStream());
        return this.readRemoteInvocationResult(httpCon.getInputStream());
    }

    protected void prepareConnection(HttpURLConnection con, int contentLength) throws IOException {
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/x-java-serialized-object");
        con.setRequestProperty("Content-Length", Integer.toString(contentLength));
    }
}

