/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.transcoders;

import net.spy.memcached.CachedData;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.transcoders.TranscoderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongTranscoder
extends SpyObject
implements Transcoder<Long> {
    private static final int flags = 768;
    private final TranscoderUtils tu = new TranscoderUtils(true);

    @Override
    public boolean asyncDecode(CachedData d) {
        return false;
    }

    @Override
    public CachedData encode(Long l) {
        return new CachedData(768, this.tu.encodeLong(l), this.getMaxSize());
    }

    @Override
    public Long decode(CachedData d) {
        if (768 == d.getFlags()) {
            return this.tu.decodeLong(d.getData());
        }
        this.getLogger().error("Unexpected flags for long:  " + d.getFlags() + " wanted " + 768);
        return null;
    }

    @Override
    public int getMaxSize() {
        return 0x100000;
    }
}

