/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.hosts;

import com.sshtools.common.hosts.AbstractHostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ConsoleHostKeyVerification
extends AbstractHostKeyVerification {
    public ConsoleHostKeyVerification() throws InvalidHostFileException {
    }

    public ConsoleHostKeyVerification(String string) throws InvalidHostFileException {
        super(string);
    }

    public void onDeniedHost(String string) {
        System.out.println("Access to the host " + string + " is denied from this system");
    }

    public void onHostKeyMismatch(String string, String string2, String string3) {
        try {
            System.out.println("The host key supplied by " + string + " is: " + string3);
            System.out.println("The current allowed key for " + string + " is: " + string2);
            this.getResponse(string, string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onUnknownHost(String string, String string2) {
        try {
            System.out.println("The host " + string + " is currently unknown to the system");
            System.out.println("The host key fingerprint is: " + string2);
            this.getResponse(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getResponse(String string, String string2) throws InvalidHostFileException, IOException {
        String string3 = "";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (!(string3.equalsIgnoreCase("YES") || string3.equalsIgnoreCase("NO") || string3.equalsIgnoreCase("ALWAYS") && this.isHostFileWriteable())) {
            String string4;
            String string5 = string4 = this.isHostFileWriteable() ? "Yes|No|Always" : "Yes|No";
            if (!this.isHostFileWriteable()) {
                System.out.println("Always option disabled, host file is not writeable");
            }
            System.out.print("Do you want to allow this host key? [" + string4 + "]: ");
            string3 = bufferedReader.readLine();
        }
        if (string3.equalsIgnoreCase("YES")) {
            this.allowHost(string, string2, false);
        }
        if (string3.equalsIgnoreCase("NO")) {
            System.out.println("Cannot continue without a valid host key");
            System.exit(1);
        }
        if (string3.equalsIgnoreCase("ALWAYS") && this.isHostFileWriteable()) {
            this.allowHost(string, string2, true);
        }
    }
}

