/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.mru;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MRUList
extends Vector {
    private static Log log = LogFactory.getLog((Class)MRUList.class);
    private static final String MRU_LIST_ELEMENT = "MRUList";
    private static final String FILE_ELEMENT = "File";
    private String currentElement = null;

    public MRUList() {
    }

    public MRUList(InputStream inputStream) throws SAXException, ParserConfigurationException, IOException {
        this();
        this.reload(inputStream);
    }

    public void reload(InputStream inputStream) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(inputStream, (DefaultHandler)new MRUSAXHandler());
    }

    public String toString() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        string = string + "<!-- Most recently used -->\n<MRUList>\n";
        Iterator iterator = this.iterator();
        File file = null;
        while (iterator.hasNext()) {
            file = (File)iterator.next();
            string = string + "   <File>" + file.getAbsolutePath() + "</" + FILE_ELEMENT + ">\n";
        }
        string = string + "</MRUList>";
        return string;
    }

    public class ElementWrapper {
        String element;
        StringBuffer text;

        ElementWrapper(String string) {
            this.element = string;
            this.text = new StringBuffer();
        }
    }

    private class MRUSAXHandler
    extends DefaultHandler {
        private String MRU_LIST_ELEMENT = "MRUList";
        private String FILE_ELEMENT = "File";
        private File currentFile = null;
        private Stack tags = new Stack();

        private MRUSAXHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ElementWrapper elementWrapper;
            ElementWrapper elementWrapper2 = elementWrapper = this.tags.size() == 0 ? null : (ElementWrapper)this.tags.peek();
            if (elementWrapper == null) {
                if (!string3.equals(this.MRU_LIST_ELEMENT)) {
                    throw new SAXException("Unexpected root element <" + string3 + ">");
                }
            } else if (elementWrapper.element.equals(this.MRU_LIST_ELEMENT)) {
                if (!string3.equals(this.FILE_ELEMENT)) {
                    throw new SAXException("Unexpected element <" + string3 + ">");
                }
            } else {
                throw new SAXException("Unexpected element <" + string3 + ">");
            }
            ElementWrapper elementWrapper3 = new ElementWrapper(string3);
            this.tags.push(elementWrapper3);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            ElementWrapper elementWrapper;
            ElementWrapper elementWrapper2 = elementWrapper = this.tags.size() == 0 ? null : (ElementWrapper)this.tags.peek();
            if (elementWrapper == null) {
                throw new SAXException("Unexpected text at " + n + " for " + n2);
            }
            elementWrapper.text.append(new String(cArray, n, n2));
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            ElementWrapper elementWrapper;
            ElementWrapper elementWrapper2 = elementWrapper = this.tags.size() == 0 ? null : (ElementWrapper)this.tags.peek();
            if (elementWrapper != null) {
                if (!elementWrapper.element.equals(string3)) {
                    throw new SAXException("Unexpected end element found <" + string3 + ">");
                }
                if (elementWrapper.element.equals(this.FILE_ELEMENT)) {
                    MRUList.this.add(new File(elementWrapper.text.toString()));
                }
                this.tags.pop();
            }
        }
    }
}

