/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.mru.MRUList;
import com.sshtools.common.mru.MRUListModel;
import com.sshtools.common.ui.MultilineLabel;
import com.sshtools.common.ui.OptionsTab;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.util.BrowserLauncher;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.IOUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplication {
    public static final String PREF_CONNECTION_LAST_HOST = "apps.connection.lastHost";
    public static final String PREF_CONNECTION_LAST_USER = "apps.connection.lastUser";
    public static final String PREF_CONNECTION_LAST_PORT = "apps.connection.lastPort";
    public static final String PREF_CONNECTION_LAST_KEY = "apps.connection.lastKey";
    public static final String PREF_LAF = "apps.laf";
    public static final String CROSS_PLATFORM_LAF = "CROSS_PLATFORM";
    public static final String DEFAULT_LAF = "DEFAULT";
    public static final String SYSTEM_LAF = "SYSTEM";
    protected static Vector containers;
    protected static Log log;
    protected static MRUListModel mruModel;
    private static UIManager.LookAndFeelInfo[] allLookAndFeelInfo;
    protected Class panelClass;
    protected Class defaultContainerClass;
    protected List additionalOptionsTabs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SshToolsApplication(Class clazz, Class clazz2) {
        this.panelClass = clazz;
        this.defaultContainerClass = clazz2;
        this.additionalOptionsTabs = new ArrayList();
        try {
            File file;
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            if ((file = this.getApplicationPreferencesDirectory()) == null) {
                throw new AccessControlException("Application preferences directory not specified.");
            }
            FileInputStream fileInputStream = null;
            MRUList mRUList = new MRUList();
            try {
                File file2 = new File(file, this.getApplicationName() + ".mru");
                if (file2.exists()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loading MRU from " + file2.getAbsolutePath()));
                    }
                    fileInputStream = new FileInputStream(file2);
                    mRUList.reload(fileInputStream);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("MRU file " + file2.getAbsolutePath() + " doesn't exist, creating empty list"));
                }
            }
            catch (Exception exception) {
                log.error((Object)"Could not load MRU list.", (Throwable)exception);
            }
            finally {
                IOUtil.closeStream(fileInputStream);
            }
            mruModel = new MRUListModel();
            mruModel.setMRUList(mRUList);
        }
        catch (AccessControlException accessControlException) {
            log.error((Object)"Could not load MRU.", (Throwable)accessControlException);
        }
    }

    public static UIManager.LookAndFeelInfo[] getAllLookAndFeelInfo() {
        return allLookAndFeelInfo;
    }

    public MRUListModel getMRUModel() {
        return mruModel;
    }

    public abstract String getApplicationName();

    public abstract String getApplicationVersion();

    public abstract Icon getApplicationLargeIcon();

    public abstract String getAboutLicenseDetails();

    public abstract String getAboutURL();

    public abstract String getAboutAuthors();

    public abstract File getApplicationPreferencesDirectory();

    public OptionsTab[] getAdditionalOptionsTabs() {
        OptionsTab[] optionsTabArray = new OptionsTab[this.additionalOptionsTabs.size()];
        this.additionalOptionsTabs.toArray(optionsTabArray);
        return optionsTabArray;
    }

    public void addAdditionalOptionsTab(OptionsTab optionsTab) {
        if (!this.additionalOptionsTabs.contains(optionsTab)) {
            this.additionalOptionsTabs.add(optionsTab);
        }
    }

    public void removeAdditionalOptionsTab(OptionsTab optionsTab) {
        this.additionalOptionsTabs.remove(optionsTab);
    }

    public void removeAdditionalOptionsTab(String string) {
        OptionsTab optionsTab = this.getOptionsTab(string);
        if (optionsTab != null) {
            this.removeAdditionalOptionsTab(optionsTab);
        }
    }

    public OptionsTab getOptionsTab(String string) {
        Iterator iterator = this.additionalOptionsTabs.iterator();
        while (iterator.hasNext()) {
            OptionsTab optionsTab = (OptionsTab)iterator.next();
            if (!optionsTab.getTabTitle().equals(string)) continue;
            return optionsTab;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        block6: {
            block7: {
                log.debug((Object)"Exiting application");
                PreferencesStore.savePreferences();
                FileOutputStream fileOutputStream = null;
                File file = this.getApplicationPreferencesDirectory();
                if (file == null) break block7;
                try {
                    File file2 = new File(this.getApplicationPreferencesDirectory(), this.getApplicationName() + ".mru");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Saving MRU to " + file2.getAbsolutePath()));
                    }
                    fileOutputStream = new FileOutputStream(file2);
                    PrintWriter printWriter = new PrintWriter(fileOutputStream, true);
                    printWriter.println(mruModel.getMRUList().toString());
                    IOUtil.closeStream((OutputStream)fileOutputStream);
                }
                catch (IOException iOException) {
                    log.error((Object)"Could not save MRU. ", (Throwable)iOException);
                    break block6;
                }
                finally {
                    IOUtil.closeStream(fileOutputStream);
                }
                break block6;
            }
            log.debug((Object)"Not saving preferences because no preferences directory is available.");
        }
        System.exit(0);
    }

    public int getContainerCount() {
        return containers.size();
    }

    public SshToolsApplicationContainer getContainerAt(int n) {
        return (SshToolsApplicationContainer)containers.elementAt(n);
    }

    public SshToolsApplicationContainer getContainerForPanel(SshToolsApplicationPanel sshToolsApplicationPanel) {
        Iterator iterator = containers.iterator();
        while (iterator.hasNext()) {
            SshToolsApplicationContainer sshToolsApplicationContainer = (SshToolsApplicationContainer)iterator.next();
            if (sshToolsApplicationContainer.getApplicationPanel() != sshToolsApplicationPanel) continue;
            return sshToolsApplicationContainer;
        }
        return null;
    }

    public void closeContainer(SshToolsApplicationContainer sshToolsApplicationContainer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Asking " + sshToolsApplicationContainer + " if it can close"));
        }
        if (sshToolsApplicationContainer.getApplicationPanel().canClose()) {
            Iterator iterator;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Closing");
                iterator = containers.iterator();
                while (iterator.hasNext()) {
                    log.debug((Object)(iterator.next() + " is currently open"));
                }
            }
            sshToolsApplicationContainer.getApplicationPanel().close();
            sshToolsApplicationContainer.closeContainer();
            containers.removeElement(sshToolsApplicationContainer);
            if (containers.size() == 0) {
                this.exit();
            } else {
                log.debug((Object)"Not closing completely because there are containers still open");
                iterator = containers.iterator();
                while (iterator.hasNext()) {
                    log.debug((Object)(iterator.next() + " is still open"));
                }
            }
        }
    }

    public void showAbout(Component component) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        JLabel jLabel = new JLabel(this.getApplicationName());
        jLabel.setFont(jLabel.getFont().deriveFont(24.0f));
        UIUtil.jGridBagAdd(jPanel, jLabel, gridBagConstraints, 0);
        JLabel jLabel2 = new JLabel(ConfigurationLoader.getVersionString((String)this.getApplicationName(), (String)this.getApplicationVersion()));
        jLabel2.setFont(jLabel2.getFont().deriveFont(10.0f));
        UIUtil.jGridBagAdd(jPanel, jLabel2, gridBagConstraints, 0);
        MultilineLabel multilineLabel = new MultilineLabel(this.getAboutAuthors());
        multilineLabel.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
        multilineLabel.setFont(multilineLabel.getFont().deriveFont(12.0f));
        UIUtil.jGridBagAdd(jPanel, multilineLabel, gridBagConstraints, 0);
        MultilineLabel multilineLabel2 = new MultilineLabel(this.getAboutLicenseDetails());
        multilineLabel2.setFont(multilineLabel2.getFont().deriveFont(10.0f));
        UIUtil.jGridBagAdd(jPanel, multilineLabel2, gridBagConstraints, 0);
        JLabel jLabel3 = new JLabel(this.getAboutURL());
        jLabel3.setForeground(Color.blue);
        jLabel3.setFont(new Font(jLabel3.getFont().getName(), 1, 10));
        jLabel3.setCursor(Cursor.getPredefinedCursor(12));
        jLabel3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    BrowserLauncher.openURL(SshToolsApplication.this.getAboutURL());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
        UIUtil.jGridBagAdd(jPanel, jLabel3, gridBagConstraints, 0);
        JOptionPane.showMessageDialog(component, jPanel, "About", -1, this.getApplicationLargeIcon());
    }

    public SshToolsApplicationContainer newContainer() throws SshToolsApplicationException {
        SshToolsApplicationContainer sshToolsApplicationContainer = null;
        try {
            sshToolsApplicationContainer = (SshToolsApplicationContainer)this.defaultContainerClass.newInstance();
            this.newContainer(sshToolsApplicationContainer);
            return sshToolsApplicationContainer;
        }
        catch (Throwable throwable) {
            throw new SshToolsApplicationException(throwable);
        }
    }

    public void newContainer(SshToolsApplicationContainer sshToolsApplicationContainer) throws SshToolsApplicationException {
        try {
            SshToolsApplicationPanel sshToolsApplicationPanel = (SshToolsApplicationPanel)this.panelClass.newInstance();
            sshToolsApplicationPanel.init(this);
            sshToolsApplicationPanel.rebuildActionComponents();
            sshToolsApplicationPanel.setAvailableActions();
            sshToolsApplicationContainer.init(this, sshToolsApplicationPanel);
            sshToolsApplicationPanel.setContainer(sshToolsApplicationContainer);
            if (!sshToolsApplicationContainer.isContainerVisible()) {
                sshToolsApplicationContainer.setContainerVisible(true);
            }
            containers.addElement(sshToolsApplicationContainer);
        }
        catch (Throwable throwable) {
            throw new SshToolsApplicationException(throwable);
        }
    }

    public SshToolsApplicationContainer convertContainer(SshToolsApplicationContainer sshToolsApplicationContainer, Class clazz) throws SshToolsApplicationException {
        log.info((Object)("Converting container of class " + sshToolsApplicationContainer.getClass().getName() + " to " + clazz.getName()));
        int n = containers.indexOf(sshToolsApplicationContainer);
        if (n == -1) {
            throw new SshToolsApplicationException("Container is not being manager by the application.");
        }
        SshToolsApplicationContainer sshToolsApplicationContainer2 = null;
        try {
            sshToolsApplicationContainer.closeContainer();
            SshToolsApplicationPanel sshToolsApplicationPanel = sshToolsApplicationContainer.getApplicationPanel();
            sshToolsApplicationContainer2 = (SshToolsApplicationContainer)clazz.newInstance();
            sshToolsApplicationContainer2.init(this, sshToolsApplicationPanel);
            sshToolsApplicationPanel.setContainer(sshToolsApplicationContainer2);
            if (!sshToolsApplicationContainer2.isContainerVisible()) {
                sshToolsApplicationContainer2.setContainerVisible(true);
            }
            containers.setElementAt(sshToolsApplicationContainer2, n);
            return sshToolsApplicationContainer2;
        }
        catch (Throwable throwable) {
            throw new SshToolsApplicationException(throwable);
        }
    }

    public void init(String[] stringArray) throws SshToolsApplicationException {
        File file = this.getApplicationPreferencesDirectory();
        if (file != null) {
            PreferencesStore.init(new File(file, this.getApplicationName() + ".properties"));
            log.info((Object)("Preferences will be saved to " + file.getAbsolutePath()));
        } else {
            log.warn((Object)"No preferences can be saved.");
        }
        try {
            SshToolsApplication.setLookAndFeel(PreferencesStore.get(PREF_LAF, SYSTEM_LAF));
            UIManager.put("OptionPane.errorIcon", new ResourceIcon(SshToolsApplication.class, "dialog-error4.png"));
            UIManager.put("OptionPane.informationIcon", new ResourceIcon(SshToolsApplication.class, "dialog-information.png"));
            UIManager.put("OptionPane.warningIcon", new ResourceIcon(SshToolsApplication.class, "dialog-warning2.png"));
            UIManager.put("OptionPane.questionIcon", new ResourceIcon(SshToolsApplication.class, "dialog-question3.png"));
        }
        catch (Throwable throwable) {
            log.error((Object)throwable);
        }
    }

    public static void setLookAndFeel(String string) throws Exception {
        LookAndFeel lookAndFeel = null;
        if (!string.equals(DEFAULT_LAF)) {
            if (string.equals(SYSTEM_LAF)) {
                String string2 = UIManager.getSystemLookAndFeelClassName();
                log.debug((Object)("System Look And Feel is " + string2));
                lookAndFeel = (LookAndFeel)Class.forName(string2).newInstance();
            } else if (string.equals(CROSS_PLATFORM_LAF)) {
                String string3 = UIManager.getCrossPlatformLookAndFeelClassName();
                log.debug((Object)("Cross Platform Look And Feel is " + string3));
                lookAndFeel = (LookAndFeel)Class.forName(string3).newInstance();
            } else {
                lookAndFeel = (LookAndFeel)Class.forName(string).newInstance();
            }
        }
        if (lookAndFeel != null) {
            log.info((Object)("Setting look and feel " + lookAndFeel.getName() + " (" + lookAndFeel.getClass().getName() + ")"));
            UIManager.setLookAndFeel(lookAndFeel);
            UIManager.put("EditorPane.font", UIManager.getFont("TextArea.font"));
        }
    }

    static {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        containers = new Vector();
        log = LogFactory.getLog((Class)SshToolsApplication.class);
        try {
            lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        }
        catch (Throwable throwable) {
            lookAndFeelInfoArray = new UIManager.LookAndFeelInfo[]{};
        }
        allLookAndFeelInfo = new UIManager.LookAndFeelInfo[lookAndFeelInfoArray.length + 3];
        System.arraycopy(lookAndFeelInfoArray, 0, allLookAndFeelInfo, 0, lookAndFeelInfoArray.length);
        SshToolsApplication.allLookAndFeelInfo[lookAndFeelInfoArray.length] = new UIManager.LookAndFeelInfo("Default", DEFAULT_LAF);
        SshToolsApplication.allLookAndFeelInfo[lookAndFeelInfoArray.length + 1] = new UIManager.LookAndFeelInfo("Cross Platform", CROSS_PLATFORM_LAF);
        SshToolsApplication.allLookAndFeelInfo[lookAndFeelInfoArray.length + 2] = new UIManager.LookAndFeelInfo("System", SYSTEM_LAF);
    }
}

