/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.openssh;

import com.sshtools.j2ssh.openssh.KeyInfo;
import com.sshtools.j2ssh.util.SimpleASNReader;
import com.sshtools.j2ssh.util.SimpleASNWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.KeySpec;

public class DSAKeyInfo
implements KeyInfo {
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;
    private BigInteger x;
    private BigInteger y;

    public DSAKeyInfo(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        this.p = bigInteger;
        this.q = bigInteger2;
        this.g = bigInteger3;
        this.x = bigInteger4;
        this.y = bigInteger5;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getX() {
        return this.x;
    }

    public BigInteger getY() {
        return this.y;
    }

    public KeySpec getPrivateKeySpec() {
        return new DSAPrivateKeySpec(this.x, this.p, this.q, this.g);
    }

    public KeySpec getPublicKeySpec() {
        return new DSAPublicKeySpec(this.y, this.p, this.q, this.g);
    }

    public static DSAKeyInfo getDSAKeyInfo(SimpleASNReader simpleASNReader) throws IOException {
        simpleASNReader.assertByte(48);
        int n = simpleASNReader.getLength();
        simpleASNReader.assertByte(2);
        byte[] byArray = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray2 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray3 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray4 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray5 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray6 = simpleASNReader.getData();
        return new DSAKeyInfo(new BigInteger(byArray2), new BigInteger(byArray3), new BigInteger(byArray4), new BigInteger(byArray6), new BigInteger(byArray5));
    }

    public static void writeDSAKeyInfo(SimpleASNWriter simpleASNWriter, DSAKeyInfo dSAKeyInfo) {
        SimpleASNWriter simpleASNWriter2 = new SimpleASNWriter();
        simpleASNWriter2.writeByte(2);
        byte[] byArray = new byte[1];
        simpleASNWriter2.writeData(byArray);
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dSAKeyInfo.getP().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dSAKeyInfo.getQ().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dSAKeyInfo.getG().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dSAKeyInfo.getY().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dSAKeyInfo.getX().toByteArray());
        byte[] byArray2 = simpleASNWriter2.toByteArray();
        simpleASNWriter.writeByte(48);
        simpleASNWriter.writeData(byArray2);
    }
}

