/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.subsystem;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.DynamicBuffer;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.subsystem.SubsystemMessageStore;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SubsystemChannel
extends Channel {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$subsystem$SubsystemChannel == null ? (class$com$sshtools$j2ssh$subsystem$SubsystemChannel = SubsystemChannel.class$("com.sshtools.j2ssh.subsystem.SubsystemChannel")) : class$com$sshtools$j2ssh$subsystem$SubsystemChannel));
    Integer exitCode = null;
    String name;
    protected SubsystemMessageStore messageStore;
    DynamicBuffer buffer = new DynamicBuffer();
    int nextMessageLength = -1;
    static /* synthetic */ Class class$com$sshtools$j2ssh$subsystem$SubsystemChannel;

    public SubsystemChannel(String string) {
        this.name = string;
        this.messageStore = new SubsystemMessageStore();
    }

    public SubsystemChannel(String string, SubsystemMessageStore subsystemMessageStore) {
        this.name = string;
        this.messageStore = subsystemMessageStore;
    }

    public String getChannelType() {
        return "session";
    }

    protected void sendMessage(SubsystemMessage subsystemMessage) throws InvalidMessageException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending " + subsystemMessage.getMessageName() + " subsystem message"));
        }
        byte[] byArray = subsystemMessage.toByteArray();
        this.sendChannelData(ByteArrayWriter.encodeInt(byArray.length));
        this.sendChannelData(byArray);
    }

    protected void onChannelRequest(String string, boolean bl, byte[] byArray) throws IOException {
        log.debug((Object)("Channel Request received: " + string));
        if (string.equals("exit-status")) {
            this.exitCode = new Integer((int)ByteArrayReader.readInt(byArray, 0));
            log.debug((Object)("Exit code of " + this.exitCode.toString() + " received"));
        } else if (string.equals("exit-signal")) {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string2 = byteArrayReader.readString();
            boolean bl2 = byteArrayReader.read() != 0;
            String string3 = byteArrayReader.readString();
            String string4 = byteArrayReader.readString();
            log.debug((Object)("Exit signal " + string2 + " received"));
            log.debug((Object)("Signal message: " + string3));
            log.debug((Object)("Core dumped: " + String.valueOf(bl2)));
        } else if (!string.equals("xon-xoff")) {
            if (string.equals("signal")) {
                String string5 = ByteArrayReader.readString(byArray, 0);
                log.debug((Object)("Signal " + string5 + " received"));
            } else if (bl) {
                this.connection.sendChannelRequestFailure(this);
            }
        }
    }

    protected void onChannelExtData(SshMsgChannelExtendedData sshMsgChannelExtendedData) throws IOException {
    }

    protected void onChannelData(SshMsgChannelData sshMsgChannelData) throws IOException {
        this.buffer.getOutputStream().write(sshMsgChannelData.getChannelData());
        byte[] byArray = new byte[4];
        while (this.buffer.getInputStream().available() > 4) {
            if (this.nextMessageLength == -1) {
                int n = 0;
                while ((n += this.buffer.getInputStream().read(byArray)) < 4) {
                }
                this.nextMessageLength = (int)ByteArrayReader.readInt(byArray, 0);
            }
            if (this.buffer.getInputStream().available() < this.nextMessageLength) break;
            byte[] byArray2 = new byte[this.nextMessageLength];
            this.buffer.getInputStream().read(byArray2);
            this.messageStore.addMessage(byArray2);
            this.nextMessageLength = -1;
        }
    }

    protected void onChannelEOF() throws IOException {
    }

    protected void onChannelClose() throws IOException {
    }

    public byte[] getChannelOpenData() {
        return null;
    }

    protected void onChannelOpen() throws IOException {
    }

    public boolean startSubsystem() throws IOException {
        log.info((Object)("Starting " + this.name + " subsystem"));
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(this.name);
        return this.connection.sendChannelRequest(this, "subsystem", true, byteArrayWriter.toByteArray());
    }

    public byte[] getChannelConfirmationData() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

