/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.TransportProtocolAlgorithmSync;
import com.sshtools.j2ssh.transport.TransportProtocolCommon;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import com.sshtools.j2ssh.transport.compression.SshCompression;
import com.sshtools.j2ssh.transport.hmac.SshHmac;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TransportProtocolOutputStream {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$transport$TransportProtocolOutputStream == null ? (class$com$sshtools$j2ssh$transport$TransportProtocolOutputStream = TransportProtocolOutputStream.class$("com.sshtools.j2ssh.transport.TransportProtocolOutputStream")) : class$com$sshtools$j2ssh$transport$TransportProtocolOutputStream));
    private OutputStream out;
    private TransportProtocolAlgorithmSync algorithms;
    private TransportProtocolCommon transport;
    private long sequenceNo = 0L;
    private long sequenceWrapLimit = BigInteger.valueOf(2L).pow(32).longValue();
    private Random rnd = ConfigurationLoader.getRND();
    private long bytesTransfered = 0L;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$TransportProtocolOutputStream;

    public TransportProtocolOutputStream(OutputStream outputStream, TransportProtocolCommon transportProtocolCommon, TransportProtocolAlgorithmSync transportProtocolAlgorithmSync) throws TransportProtocolException {
        this.out = outputStream;
        this.transport = transportProtocolCommon;
        this.algorithms = transportProtocolAlgorithmSync;
    }

    protected long getNumBytesTransfered() {
        return this.bytesTransfered;
    }

    protected synchronized void sendMessage(SshMessage sshMessage) throws TransportProtocolException {
        block7: {
            try {
                this.algorithms.lock();
                SshCipher sshCipher = this.algorithms.getCipher();
                SshHmac sshHmac = this.algorithms.getHmac();
                SshCompression sshCompression = this.algorithms.getCompression();
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byte[] byArray = sshMessage.toByteArray();
                int n = 4;
                int n2 = 8;
                if (sshCipher != null) {
                    n2 = sshCipher.getBlockSize();
                }
                if (sshCompression != null) {
                    byArray = sshCompression.compress(byArray, 0, byArray.length);
                }
                n += (n2 - (byArray.length + 5 + n) % n2) % n2;
                byteArrayWriter.writeInt(byArray.length + 1 + n);
                byteArrayWriter.write(n);
                byteArrayWriter.write(byArray, 0, byArray.length);
                byte[] byArray2 = new byte[n];
                this.rnd.nextBytes(byArray2);
                byteArrayWriter.write(byArray2);
                byte[] byArray3 = byteArrayWriter.toByteArray();
                byte[] byArray4 = null;
                if (sshHmac != null) {
                    byArray4 = sshHmac.generate(this.sequenceNo, byArray3, 0, byArray3.length);
                }
                if (sshCipher != null) {
                    byArray3 = sshCipher.transform(byArray3);
                }
                byteArrayWriter.reset();
                byteArrayWriter.write(byArray3);
                if (byArray4 != null) {
                    byteArrayWriter.write(byArray4);
                }
                this.bytesTransfered += (long)byteArrayWriter.size();
                this.out.write(byteArrayWriter.toByteArray());
                this.out.flush();
                this.algorithms.release();
                this.sequenceNo = this.sequenceNo < this.sequenceWrapLimit ? ++this.sequenceNo : 0L;
            }
            catch (IOException iOException) {
                if (this.transport.getState().getValue() == 5) break block7;
                throw new TransportProtocolException("IO Error on socket: " + iOException.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

