/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.KBIAuthenticationClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.io.FilePermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAuthenticationClientFactory {
    private static Map auths;
    private static Log log;
    public static final String AUTH_PASSWORD = "password";
    public static final String AUTH_PK = "publickey";
    public static final String AUTH_KBI = "keyboard-interactive";
    public static final String AUTH_HOSTBASED = "hostbased";

    protected SshAuthenticationClientFactory() {
    }

    public static void initialize() {
    }

    public static List getSupportedMethods() {
        ArrayList arrayList = new ArrayList(auths.keySet());
        return arrayList;
    }

    public static SshAuthenticationClient newInstance(String string) throws AlgorithmNotSupportedException {
        try {
            return (SshAuthenticationClient)((Class)auths.get(string)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(string + " is not supported!");
        }
    }

    static {
        log = LogFactory.getLog((Class)SshAuthenticationClientFactory.class);
        auths = new HashMap();
        log.info((Object)"Loading supported authentication methods");
        auths.put(AUTH_PASSWORD, PasswordAuthenticationClient.class);
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
            auths.put(AUTH_PK, PublicKeyAuthenticationClient.class);
        }
        catch (AccessControlException accessControlException) {
            log.info((Object)"The security manager prevents use of Public Key Authentication on the client");
        }
        auths.put(AUTH_KBI, KBIAuthenticationClient.class);
        try {
            if (ConfigurationLoader.isConfigurationAvailable(SshAPIConfiguration.class)) {
                SshAPIConfiguration sshAPIConfiguration = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(SshAPIConfiguration.class);
                List list = sshAPIConfiguration.getAuthenticationExtensions();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ExtensionAlgorithm extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
                    String string = extensionAlgorithm.getAlgorithmName();
                    if (auths.containsKey(string)) {
                        log.debug((Object)("Standard authentication implementation for " + string + " is being overidden by " + extensionAlgorithm.getImplementationClass()));
                    } else {
                        log.debug((Object)(string + " authentication is implemented by " + extensionAlgorithm.getImplementationClass()));
                    }
                    try {
                        Class clazz = ConfigurationLoader.getExtensionClass(extensionAlgorithm.getImplementationClass());
                        Object t = clazz.newInstance();
                        if (!(t instanceof SshAuthenticationClient)) continue;
                        auths.put(string, clazz);
                    }
                    catch (Exception exception) {
                        log.warn((Object)("Failed to load extension authentication implementation" + extensionAlgorithm.getImplementationClass()), (Throwable)exception);
                    }
                }
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }
}

