/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.TransportProtocolAlgorithmSync;
import com.sshtools.j2ssh.transport.TransportProtocolCommon;
import com.sshtools.j2ssh.transport.TransportProtocolEventHandler;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import com.sshtools.j2ssh.transport.compression.SshCompression;
import com.sshtools.j2ssh.transport.hmac.SshHmac;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.math.BigInteger;
import java.net.SocketException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TransportProtocolInputStream {
    private static Log log = LogFactory.getLog((Class)TransportProtocolInputStream.class);
    private long bytesTransfered = 0L;
    private BufferedInputStream in;
    private Object sequenceLock = new Object();
    private TransportProtocolCommon transport;
    private TransportProtocolAlgorithmSync algorithms;
    private long sequenceNo = 0L;
    private long sequenceWrapLimit = BigInteger.valueOf(2L).pow(32).longValue();
    private SshCipher cipher;
    private SshHmac hmac;
    private SshCompression compression;
    int msglen;
    int padlen;
    int read;
    int remaining;
    int cipherlen = 8;
    int maclen = 0;
    ByteArrayWriter message = new ByteArrayWriter();
    byte[] initial = new byte[this.cipherlen];
    byte[] data = new byte[65535];
    byte[] buffered = new byte[65535];
    int startpos = 0;
    int endpos = 0;

    public TransportProtocolInputStream(TransportProtocolCommon transportProtocolCommon, InputStream inputStream, TransportProtocolAlgorithmSync transportProtocolAlgorithmSync) throws IOException {
        this.transport = transportProtocolCommon;
        this.in = new BufferedInputStream(inputStream);
        this.algorithms = transportProtocolAlgorithmSync;
    }

    public synchronized long getSequenceNo() {
        return this.sequenceNo;
    }

    protected long getNumBytesTransfered() {
        return this.bytesTransfered;
    }

    protected int available() {
        return this.endpos - this.startpos;
    }

    protected int readBufferedData(byte[] byArray, int n, int n2) throws IOException {
        if (this.endpos - this.startpos < n2) {
            if (this.buffered.length - this.endpos < n2) {
                System.arraycopy(this.buffered, this.startpos, this.buffered, 0, this.endpos - this.startpos);
                this.endpos -= this.startpos;
                this.startpos = 0;
                if (this.buffered.length - this.endpos < n2) {
                    byte[] byArray2 = new byte[this.buffered.length + n2];
                    System.arraycopy(this.buffered, 0, byArray2, 0, this.endpos);
                    this.buffered = byArray2;
                }
            }
            while (this.endpos - this.startpos < n2 && this.transport.getState().getValue() != 5) {
                int n3;
                try {
                    n3 = this.in.read(this.buffered, this.endpos, this.buffered.length - this.endpos);
                }
                catch (InterruptedIOException interruptedIOException) {
                    n3 = interruptedIOException.bytesTransferred;
                    Iterator iterator = this.transport.getEventHandlers().iterator();
                    while (iterator.hasNext()) {
                        TransportProtocolEventHandler transportProtocolEventHandler = (TransportProtocolEventHandler)iterator.next();
                        transportProtocolEventHandler.onSocketTimeout(this.transport);
                    }
                }
                if (n3 < 0) {
                    throw new IOException("The socket is EOF");
                }
                this.endpos += n3;
            }
        }
        try {
            System.arraycopy(this.buffered, this.startpos, byArray, n, n2);
        }
        catch (Throwable throwable) {
            System.out.println();
        }
        this.startpos += n2;
        if (this.startpos >= this.endpos) {
            this.endpos = 0;
            this.startpos = 0;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readMessage() throws SocketException, IOException {
        int n;
        this.message.reset();
        this.read = this.readBufferedData(this.initial, 0, this.cipherlen);
        this.cipher = this.algorithms.getCipher();
        this.hmac = this.algorithms.getHmac();
        this.compression = this.algorithms.getCompression();
        this.cipherlen = this.cipher != null ? this.cipher.getBlockSize() : 8;
        if (this.initial.length != this.cipherlen) {
            byte[] byArray = new byte[this.cipherlen];
            System.arraycopy(this.initial, 0, byArray, 0, this.initial.length);
            this.initial = byArray;
        }
        if ((n = this.read) < this.initial.length) {
            n += this.readBufferedData(this.initial, n, this.initial.length - n);
        }
        this.maclen = this.hmac != null ? this.hmac.getMacLength() : 0;
        if (this.cipher != null) {
            this.initial = this.cipher.transform(this.initial);
        }
        this.message.write(this.initial);
        this.msglen = (int)ByteArrayReader.readInt(this.initial, 0);
        this.padlen = this.initial[4];
        this.remaining = this.msglen - (this.cipherlen - 4);
        while (this.remaining > 0) {
            this.read = this.readBufferedData(this.data, 0, this.remaining < this.data.length ? this.remaining / this.cipherlen * this.cipherlen : this.data.length / this.cipherlen * this.cipherlen);
            this.remaining -= this.read;
            this.message.write(this.cipher == null ? this.data : this.cipher.transform(this.data, 0, this.read), 0, this.read);
        }
        Object object = this.sequenceLock;
        synchronized (object) {
            if (this.hmac != null) {
                this.read = this.readBufferedData(this.data, 0, this.maclen);
                this.message.write(this.data, 0, this.read);
                if (!this.hmac.verify(this.sequenceNo, this.message.toByteArray())) {
                    throw new IOException("Corrupt Mac on input");
                }
            }
            this.sequenceNo = this.sequenceNo < this.sequenceWrapLimit ? ++this.sequenceNo : 0L;
        }
        this.bytesTransfered += (long)this.message.size();
        object = this.message.toByteArray();
        if (this.compression != null) {
            return this.compression.uncompress((byte[])object, 5, this.msglen + 4 - this.padlen - 5);
        }
        return object;
    }
}

