/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.dsa.SshDssKeyPair;
import com.sshtools.j2ssh.transport.publickey.rsa.SshRsaKeyPair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshKeyPairFactory {
    private static Map pks;
    private static String defaultAlgorithm;
    private static Log log;

    protected SshKeyPairFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultPublicKey() {
        return defaultAlgorithm;
    }

    public static List getSupportedKeys() {
        return new ArrayList(pks.keySet());
    }

    public static SshKeyPair newInstance(String string) throws AlgorithmNotSupportedException {
        try {
            return (SshKeyPair)((Class)pks.get(string)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(string + " is not supported!");
        }
    }

    public static boolean supportsKey(String string) {
        return pks.containsKey(string);
    }

    public static SshPrivateKey decodePrivateKey(byte[] byArray) throws InvalidSshKeyException, AlgorithmNotSupportedException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (SshKeyPairFactory.supportsKey(string)) {
                SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
                return sshKeyPair.decodePrivateKey(byArray);
            }
            throw new AlgorithmNotSupportedException(string + " is not supported");
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException.getMessage());
        }
    }

    public static SshPublicKey decodePublicKey(byte[] byArray) throws InvalidSshKeyException, AlgorithmNotSupportedException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (SshKeyPairFactory.supportsKey(string)) {
                SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
                return sshKeyPair.decodePublicKey(byArray);
            }
            throw new AlgorithmNotSupportedException(string + " is not supported");
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException.getMessage());
        }
    }

    static {
        Object object;
        log = LogFactory.getLog((Class)SshKeyPairFactory.class);
        pks = new HashMap();
        log.info((Object)"Loading public key algorithms");
        pks.put("ssh-dss", SshDssKeyPair.class);
        pks.put("ssh-rsa", SshRsaKeyPair.class);
        try {
            if (ConfigurationLoader.isConfigurationAvailable(SshAPIConfiguration.class) && (object = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(SshAPIConfiguration.class)) != null) {
                List list = object.getPublicKeyExtensions();
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ExtensionAlgorithm extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
                        String string = extensionAlgorithm.getAlgorithmName();
                        if (pks.containsKey(string)) {
                            log.debug((Object)("Standard public key " + string + " is being overidden by " + extensionAlgorithm.getImplementationClass()));
                        } else {
                            log.debug((Object)(extensionAlgorithm.getAlgorithmName() + " public key is implemented by " + extensionAlgorithm.getImplementationClass()));
                        }
                        try {
                            pks.put(extensionAlgorithm.getAlgorithmName(), ConfigurationLoader.getExtensionClass(extensionAlgorithm.getImplementationClass()));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            log.error((Object)("Could not locate " + extensionAlgorithm.getImplementationClass()));
                        }
                    }
                }
                defaultAlgorithm = object.getDefaultPublicKey();
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (defaultAlgorithm == null || !pks.containsKey(defaultAlgorithm)) {
            log.debug((Object)"The default public key is not set! using first in list");
            object = pks.keySet().iterator();
            defaultAlgorithm = (String)object.next();
        }
    }
}

