/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.terminal;

import com.sshtools.daemon.terminal.ColorHelper;

public final class Colorizer {
    private static Object Self;
    private static int testcount;
    private static Colorizer myColorizer;
    private static final int S = 30;
    private static final int s = 40;
    private static final int R = 31;
    private static final int r = 41;
    private static final int G = 32;
    private static final int g = 42;
    private static final int Y = 33;
    private static final int y = 43;
    private static final int B = 34;
    private static final int b = 44;
    private static final int M = 35;
    private static final int m = 45;
    private static final int C = 36;
    private static final int c = 46;
    private static final int W = 37;
    private static final int w = 47;
    private static final int f = 1;
    private static final int d = 22;
    private static final int i = 3;
    private static final int j = 23;
    private static final int u = 4;
    private static final int v = 24;
    private static final int e = 5;
    private static final int n = 25;
    private static final int h = 8;
    private static final int a = 0;
    private int[] colortranslation = new int[128];
    private int leng;

    private Colorizer() {
        this.colortranslation[83] = 30;
        this.colortranslation[82] = 31;
        this.colortranslation[71] = 32;
        this.colortranslation[89] = 33;
        this.colortranslation[66] = 34;
        this.colortranslation[77] = 35;
        this.colortranslation[67] = 36;
        this.colortranslation[87] = 37;
        this.colortranslation[115] = 40;
        this.colortranslation[114] = 41;
        this.colortranslation[103] = 42;
        this.colortranslation[121] = 43;
        this.colortranslation[98] = 44;
        this.colortranslation[109] = 45;
        this.colortranslation[99] = 46;
        this.colortranslation[119] = 47;
        this.colortranslation[102] = 1;
        this.colortranslation[100] = 22;
        this.colortranslation[105] = 3;
        this.colortranslation[106] = 23;
        this.colortranslation[117] = 4;
        this.colortranslation[118] = 24;
        this.colortranslation[101] = 5;
        this.colortranslation[110] = 25;
        this.colortranslation[104] = 8;
        this.colortranslation[97] = 0;
        Self = this;
    }

    public String colorize(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        while (!bl2) {
            n2 = string.indexOf(1, n);
            if (n2 != -1) {
                stringBuffer.append(string.substring(n, n2));
                if (bl) {
                    stringBuffer.append(this.addEscapeSequence(string.substring(n2 + 1, n2 + 2)));
                }
                n = n2 + 2;
                continue;
            }
            stringBuffer.append(string.substring(n, string.length()));
            bl2 = true;
        }
        if (bl) {
            stringBuffer.append(this.addEscapeSequence("a"));
        }
        return stringBuffer.toString();
    }

    private String addEscapeSequence(String string) {
        StringBuffer stringBuffer = new StringBuffer(10);
        byte[] byArray = string.getBytes();
        byte by = byArray[0];
        stringBuffer.append('\u001b');
        stringBuffer.append('[');
        stringBuffer.append(new Integer(this.colortranslation[by]).toString());
        stringBuffer.append('m');
        return stringBuffer.toString();
    }

    public static Colorizer getReference() {
        if (Self != null) {
            return (Colorizer)Self;
        }
        return new Colorizer();
    }

    private static void announceResult(boolean bl) {
        if (bl) {
            System.out.println("[#" + testcount + "] ok.");
        } else {
            System.out.println("[#" + testcount + "] failed (see possible StackTrace).");
        }
    }

    private static void announceTest(String string) {
        System.out.println("Test #" + ++testcount + " [" + string + "]:");
    }

    private static void bfcolorTest(String string) {
        System.out.println("->" + myColorizer.colorize(ColorHelper.boldcolorizeText("COLOR", string), true) + "<-");
    }

    private static void fcolorTest(String string) {
        System.out.println("->" + myColorizer.colorize(ColorHelper.colorizeText("COLOR", string), true) + "<-");
    }

    private static void bcolorTest(String string) {
        System.out.println("->" + myColorizer.colorize(ColorHelper.colorizeBackground("     ", string), true) + "<-");
    }

    public static void main(String[] stringArray) {
        try {
            Colorizer.announceTest("Instantiation");
            myColorizer = Colorizer.getReference();
            Colorizer.announceResult(true);
            Colorizer.announceTest("Textcolor Tests");
            Colorizer.fcolorTest("S");
            Colorizer.fcolorTest("R");
            Colorizer.fcolorTest("G");
            Colorizer.fcolorTest("Y");
            Colorizer.fcolorTest("B");
            Colorizer.fcolorTest("M");
            Colorizer.fcolorTest("C");
            Colorizer.fcolorTest("W");
            Colorizer.announceResult(true);
            Colorizer.announceTest("Bold textcolor Tests");
            Colorizer.bfcolorTest("S");
            Colorizer.bfcolorTest("R");
            Colorizer.bfcolorTest("G");
            Colorizer.bfcolorTest("Y");
            Colorizer.bfcolorTest("B");
            Colorizer.bfcolorTest("M");
            Colorizer.bfcolorTest("C");
            Colorizer.bfcolorTest("W");
            Colorizer.announceResult(true);
            Colorizer.announceTest("Background Tests");
            Colorizer.bcolorTest("S");
            Colorizer.bcolorTest("R");
            Colorizer.bcolorTest("G");
            Colorizer.bcolorTest("Y");
            Colorizer.bcolorTest("B");
            Colorizer.bcolorTest("M");
            Colorizer.bcolorTest("C");
            Colorizer.bcolorTest("W");
            Colorizer.announceResult(true);
            Colorizer.announceTest("Mixed Color Tests");
            System.out.println("->" + myColorizer.colorize(ColorHelper.colorizeText("COLOR", "W", "B"), true) + "<-");
            System.out.println("->" + myColorizer.colorize(ColorHelper.colorizeText("COLOR", "Y", "G"), true) + "<-");
            System.out.println("->" + myColorizer.colorize(ColorHelper.boldcolorizeText("COLOR", "W", "B"), true) + "<-");
            System.out.println("->" + myColorizer.colorize(ColorHelper.boldcolorizeText("COLOR", "Y", "G"), true) + "<-");
            Colorizer.announceResult(true);
            Colorizer.announceTest("Style Tests");
            System.out.println("->" + myColorizer.colorize(ColorHelper.boldText("Bold"), true) + "<-");
            System.out.println("->" + myColorizer.colorize(ColorHelper.italicText("Italic"), true) + "<-");
            System.out.println("->" + myColorizer.colorize(ColorHelper.underlinedText("Underlined"), true) + "<-");
            System.out.println("->" + myColorizer.colorize(ColorHelper.blinkingText("Blinking"), true) + "<-");
            Colorizer.announceResult(true);
            Colorizer.announceTest("Visible length test");
            String string = ColorHelper.boldcolorizeText("STRING", "Y");
            System.out.println("->" + myColorizer.colorize(string, true) + "<-");
            System.out.println("Visible length=" + ColorHelper.getVisibleLength(string));
            string = ColorHelper.boldcolorizeText("BANNER", "W", "B") + ColorHelper.colorizeText("COLOR", "W", "B") + ColorHelper.underlinedText("UNDER");
            System.out.println("->" + myColorizer.colorize(string, true) + "<-");
            System.out.println("Visible length=" + ColorHelper.getVisibleLength(string));
            Colorizer.announceResult(true);
        }
        catch (Exception exception) {
            Colorizer.announceResult(false);
            exception.printStackTrace();
        }
    }

    static {
        testcount = 0;
    }
}

